package com.mcd.restaurant.model;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.ToString;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;

@Entity
@Data
@Table(name = "components", indexes = {@Index(name = "components_id_IX", columnList = "id", unique = true)})
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonApiResource(type = "components")
public class Component implements Serializable {
    @Id
    @Column(unique = true, nullable = false)
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @JsonApiId
    private int id;

    @Column(nullable = false)
    private String name;

    @Column(name = "display_name")
    private String displayName;

    @Column(name = "identification_name")
    private String identificationName;

    @Column(name = "model_number", nullable = false)
    private String modelNumber = "0";

    @Column(name = "hardware_version")
    private String hardwareVersion;

    @Column(name = "serial_number", nullable = false)
    private String serialNumber = "0";

    @Column
    private Timestamp warranty;

    @Column(name = "install_date")
    private Timestamp installDate;

    @Column(name = "reported_version")
    private String reportedVersion;

    @CreationTimestamp
    private Timestamp created;

    @UpdateTimestamp
    private Timestamp updated;

    @OneToMany(mappedBy = "component")
    @JsonIgnoreProperties("component")
    @JsonApiRelation(mappedBy = "component")
    @ToString.Exclude
    private List<ComponentAuditHistory> componentAuditHistory;

    @OneToMany(mappedBy = "component")
    @JsonIgnoreProperties("component")
    @JsonApiRelation(mappedBy = "component")
    @ToString.Exclude
    private List<ComponentProp> componentProps;

    @ManyToOne
    @JoinColumn(name = "vendor_id")
    @JsonIgnoreProperties("components")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Vendor vendor;

    @Column(name = "parent_id")
    private Integer parentComponent;

    @ManyToOne
    @JoinColumn(name = "restaurant_id", nullable = false)
    @JsonIgnoreProperties("components")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private Restaurant restaurant;

    @ManyToOne
    @JoinColumn(name = "component_group_id")
    @JsonIgnoreProperties("components")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ComponentGroup componentGroup;

    @ManyToOne
    @JoinColumn(name = "type", referencedColumnName = "name")
    @JsonIgnoreProperties("components")
    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    @ToString.Exclude
    private ComponentType type;

}
