package com.mcd.restaurant.deployment.controller.view.beans;

import com.mcd.restaurant.model.DeploymentHistory;
import com.mcd.restaurant.model.DeploymentTag;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelation;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import lombok.*;
import org.hibernate.annotations.CreationTimestamp;

import javax.persistence.Column;
import javax.persistence.Id;
import java.sql.Timestamp;
import java.util.List;

@Data
@Generated
@Builder
@JsonApiResource(type = "deployment_queue", postable = false, patchable = false, deletable = false
)
@NoArgsConstructor
@AllArgsConstructor
public class DeploymentQueueData {
    @Id
    @JsonApiId
    private int id;

    @CreationTimestamp
    private Timestamp created;
    @Column
    private Timestamp scheduled;

    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    private DeploymentTag deploymentTag;

    @JsonApiRelation(repositoryBehavior = RelationshipRepositoryBehavior.FORWARD_OWNER)
    private List<DeploymentHistory> deploymentHistory;

    @Column
    private String type;

    @Column
    private String deploymentName;

    @Column
    private String status;

    @Column(name = "deployed_version")
    private String deployedVersion;

    @Column
    private String deployedBy;

    @Column
    private String restaurantDetail;


}
