package com.mcd.restaurant.dashboard.utils.csvfilter;

import com.mcd.restaurant.dashboard.controller.view.request.HierarchyStructureBean;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;


import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;


public class NodeTypeFilter implements CsvToBeanFilter {
    private final MappingStrategy<HierarchyStructureBean> strategy;
    private final String nodetype;
    private final String priority;
    private static final String NODE_TYPE_COLUMN = "Node Type";
    private static final String PRIORITY_COLUMN = "Priority";


    public NodeTypeFilter(MappingStrategy<HierarchyStructureBean> strategy, String nodetype, String priority) {
        this.strategy = strategy;
        this.nodetype = nodetype;
        this.priority = priority;
    }

    @Override
    public boolean allowLine(String[] strings) {
        List<String> headers = Stream.of(strategy.generateHeader()).collect(Collectors.toList());
        int nodeTypeIndex = headers.indexOf(NODE_TYPE_COLUMN);
        int priorityIndex = headers.indexOf(PRIORITY_COLUMN);
        if (nodeTypeIndex == -1 && NODE_TYPE_COLUMN.equals(headers.get(0).substring(1))) {
                nodeTypeIndex = 0;
        }
        if (priorityIndex == -1 && PRIORITY_COLUMN.equals(headers.get(0).substring(1))) {
                priorityIndex = 0;
        }
        String nodeTypValue = strings[nodeTypeIndex];
        String priorityValue = strings[priorityIndex];
        return nodetype.equalsIgnoreCase(nodeTypValue) && priority.equalsIgnoreCase(priorityValue);
    }


}
