package com.mcd.restaurant.dashboard.utils.csvfilter;

import com.mcd.restaurant.dashboard.controller.view.request.NetworkStructureBean;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NetworkNodeTypeFilter implements CsvToBeanFilter {
    private final MappingStrategy<NetworkStructureBean> strategy;
    private static final String STORE_NUMBER_NODE = "National Store #";
    private static final String IP_ADDRESS_NODE = "Service-Network Segment";

    public NetworkNodeTypeFilter(MappingStrategy<NetworkStructureBean> strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean allowLine(String[] strings) {
        List<String> headers = Stream.of(strategy.generateHeader()).collect(Collectors.toList());
        int storeNoIndex = headers.indexOf(STORE_NUMBER_NODE);
        int ipAddressIndex = headers.indexOf(IP_ADDRESS_NODE);
        if (storeNoIndex == -1 && STORE_NUMBER_NODE.equals(headers.get(0).substring(1))) {
            storeNoIndex = 0;
        }
        if (ipAddressIndex == -1 && IP_ADDRESS_NODE.equals(headers.get(0).substring(1))) {
            ipAddressIndex = 0;
        }
        return (!StringUtils.isBlank(strings[storeNoIndex]) && !StringUtils.isBlank(strings[ipAddressIndex]));

    }
}
