package com.mcd.restaurant.dashboard.enums;

public enum StoreDemographicStructure {
    NODE_TYPE("NODE TYPE", "nodetype"), NODE_NAME("NODE NAME", "nodeName"), RESTAURANT_NUMBER("RESTAURANT NUMBER", "restaurantNumber"), ADDRESS("ADDRESS", "storeAddress"), LATITUDE("LATITUDE", "latitude"), LONGITUDE("LONGITUDE", "longitude"), CITY("CITY", "city"), STATE("STATE", "state"), COUNTRY("COUNTRY", "country"), ZIP("ZIP", "zipCode"), PHONE("PHONE", "contactNumber"), OWNER_NAME("OWNER NAME", "ownerName"), OWNER_TYPE("OWNER TYPE", "ownerType");

    private final String key;
    private final String value;


    StoreDemographicStructure(String k, String v) {
        key = k;
        value = v;
    }

    public String getValue() {
        return value;
    }

    public String getKey() {
        return key;
    }

    public static String getValueFromKey(String key) {
        for (StoreDemographicStructure structure : StoreDemographicStructure.values()) {
            if (structure.getKey().equals(key)) {
                return structure.getValue();
            }
        }
        return null;
    }
}
