package com.mcd.restaurant.dashboard.enums;

public enum NetworkStructure {
    STORE_NO("National Store #", "restaurant"), IP_ADDRESS("Service-Network Segment", "ipAddress");

    private final String key;
    private final String value;


    NetworkStructure(String k, String v) {
        key = k;
        value = v;
    }

    public String getValue() {
        return value;
    }

    public String getKey() {
        return key;
    }

    public static String getValueFromKey(String key) {
        for (NetworkStructure structure : NetworkStructure.values()) {
            if (structure.getKey().equals(key)) {
                return structure.getValue();
            }
        }
        return null;
    }
}
