package com.mcd.restaurant.component.controller;


import com.mcd.restaurant.common.ResponseView;
import com.mcd.restaurant.component.controller.view.request.DeviceRequestDTO;
import com.mcd.restaurant.component.controller.view.response.DeviceDetailResponseDTO;
import com.mcd.restaurant.component.service.ComponentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path = "/component")
public class ComponentController {

    @Autowired
    ComponentService componentService;

    /**
     * This API insert Axis Device information
     */
    @PostMapping(path = "/device")
    public ResponseEntity<ResponseView<DeviceDetailResponseDTO>> insertDeviceData(
            @RequestBody DeviceRequestDTO deviceRequestDTO) {
        ResponseView<DeviceDetailResponseDTO> responseView = new ResponseView<>();
        responseView.setData(componentService.deviceDetails(deviceRequestDTO.getDeviceDetail()));
        return ResponseEntity.status(HttpStatus.CREATED).body(responseView);
    }

}
