# BRE Restaurant Assets Service

This repository contains the BRE restaurant assets service / API.

## Usage (with Docker)
1. Make sure Docker is installed locally
2. Open the command line interface and navigate to the root of the source directory
3. In `/src/main/resources/application.properties` file, configure the source database that you want the service to use. The properties that need to be configured are `spring.datasource.url`, `spring.datasource.username`, and `spring.datasource.password`. Make sure the database host is accessible from the Docker container, where the service is deployed. If the database is hosted locally on the same server as the Docker host, the hostname to be used in the `spring.datasource.url` property is, `host.docker.internal`. How to set up the local database is explained in the section below, "How to set up the Bre Menu database locally". Instead of modifying these in `application.properties` file, you can override these properties in the `docker run` command in step 6.
4. In the root directory, run:
```bash
docker build -t restaurant-assets .
```
5. Make sure you can see the image and its image ID that you just built by running following command: docker images
6. When that's finished, start the application:

```bash
docker run -p 8080:8080 -e SPRING_DATASOURCE_URL=<url> -e SPRING_DATASOURCE_USERNAME=<username> -e SPRING_DATASOURCE_PASSWORD=<password> restaurant-assets
```

The output should look like:

```
.   ____          _            __ _ _
/\\ / ___'_ __ _ _(_)_ __  __ _ \ \ \ \
( ( )\___ | '_ | '_| | '_ \/ _` | \ \ \ \
\\/  ___)| |_)| | | | | || (_| |  ) ) ) )
'  |____| .__|_| |_|_| |_\__, | / / / /
=========|_|==============|___/=/_/_/_/
:: Spring Boot ::        (v2.1.7.RELEASE)

2019-10-10 18:14:53.729  INFO 1 --- [           main] c.m.r.RestaurantAssetsApplication        : Starting RestaurantAssetsApplication on 8b73e85fe069 with PID 1 (/app started by root in /)
2019-10-10 18:14:53.735  INFO 1 --- [           main] c.m.r.RestaurantAssetsApplication        : No active profile set, falling back to default profiles: default
2019-10-10 18:14:55.059  INFO 1 --- [           main] .s.d.r.c.RepositoryConfigurationDelegate : Bootstrapping Spring Data repositories in DEFAULT mode.
2019-10-10 18:14:55.123  INFO 1 --- [           main] .s.d.r.c.RepositoryConfigurationDelegate : Finished Spring Data repository scanning in 38ms. Found 0 repository interfaces.
2019-10-10 18:14:55.879  INFO 1 --- [           main] trationDelegate$BeanPostProcessorChecker : Bean 'org.springframework.transaction.annotation.ProxyTransactionManagementConfiguration' of type [org.springframework.transaction.annotation.ProxyTransactionManagementConfiguration$$EnhancerBySpringCGLIB$$35f28e22] is not eligible for getting processed by all BeanPostProcessors (for example: not eligible for auto-proxying)
2019-10-10 18:14:55.929  INFO 1 --- [           main] trationDelegate$BeanPostProcessorChecker : Bean 'org.springframework.hateoas.config.HateoasConfiguration' of type [org.springframework.hateoas.config.HateoasConfiguration$$EnhancerBySpringCGLIB$$b572db54] is not eligible for getting processed by all BeanPostProcessors (for example: not eligible for auto-proxying)
2019-10-10 18:14:56.583  INFO 1 --- [           main] o.s.b.w.embedded.tomcat.TomcatWebServer  : Tomcat initialized with port(s): 8080 (http)
2019-10-10 18:14:56.642  INFO 1 --- [           main] o.apache.catalina.core.StandardService   : Starting service [Tomcat]
2019-10-10 18:14:56.643  INFO 1 --- [           main] org.apache.catalina.core.StandardEngine  : Starting Servlet engine: [Apache Tomcat/9.0.22]
2019-10-10 18:14:56.978  INFO 1 --- [           main] o.a.c.c.C.[Tomcat].[localhost].[/]       : Initializing Spring embedded WebApplicationContext
2019-10-10 18:14:56.978  INFO 1 --- [           main] o.s.web.context.ContextLoader            : Root WebApplicationContext: initialization completed in 3145 ms
2019-10-10 18:14:57.661  INFO 1 --- [           main] com.zaxxer.hikari.HikariDataSource       : HikariPool-1 - Starting...
2019-10-10 18:14:58.743  INFO 1 --- [           main] com.zaxxer.hikari.HikariDataSource       : HikariPool-1 - Start completed.
2019-10-10 18:14:58.942  INFO 1 --- [           main] o.hibernate.jpa.internal.util.LogHelper  : HHH000204: Processing PersistenceUnitInfo [
name: default
...]
2019-10-10 18:14:59.159  INFO 1 --- [           main] org.hibernate.Version                    : HHH000412: Hibernate Core {5.3.10.Final}
2019-10-10 18:14:59.162  INFO 1 --- [           main] org.hibernate.cfg.Environment            : HHH000206: hibernate.properties not found
2019-10-10 18:14:59.571  INFO 1 --- [           main] o.hibernate.annotations.common.Version   : HCANN000001: Hibernate Commons Annotations {5.0.4.Final}
2019-10-10 18:14:59.956  INFO 1 --- [           main] org.hibernate.dialect.Dialect            : HHH000400: Using dialect: org.hibernate.dialect.MySQL5InnoDBDialect
2019-10-10 18:15:03.967  INFO 1 --- [           main] j.LocalContainerEntityManagerFactoryBean : Initialized JPA EntityManagerFactory for persistence unit 'default'
2019-10-10 18:15:04.432  WARN 1 --- [           main] aWebConfiguration$JpaWebMvcConfiguration : spring.jpa.open-in-view is enabled by default. Therefore, database queries may be performed during view rendering. Explicitly configure spring.jpa.open-in-view to disable this warning
2019-10-10 18:15:05.120  INFO 1 --- [           main] io.crnk.core.boot.CrnkBoot               : crnk initialized: numResources=29, usedModules=[jackson, servlet, spring.exception, jpa, meta, spring.mvc], securityProviders=[ServletSecurityProvider], pagingBehaviors=[OffsetLimitPagingBehavior], urlMapper=DefaultQuerySpecUrlMapper, serviceDiscovery=SpringServiceDiscovery
2019-10-10 18:15:06.042  INFO 1 --- [           main] o.s.s.concurrent.ThreadPoolTaskExecutor  : Initializing ExecutorService 'applicationTaskExecutor'
2019-10-10 18:15:06.940  INFO 1 --- [           main] o.s.b.w.embedded.tomcat.TomcatWebServer  : Tomcat started on port(s): 8080 (http) with context path ''
2019-10-10 18:15:06.946  INFO 1 --- [           main] c.m.r.RestaurantAssetsApplication        : Started RestaurantAssetsApplication in 13.907 seconds (JVM running for 15.031)
```

7. It will show the logs of the application starting up. Verify it starts without any errors and test the api endpoint by sending a GET request (Ex: http://localhost:8080/actuator/health)
8. Or, you can make a request to the API's actual endpoint, such as:

```bash
curl -X GET \
  http://localhost:8080/restaurant_assets/components/ \
  -H 'Accept: */*' \
  -H 'Accept-Encoding: gzip, deflate' \
  -H 'Cache-Control: no-cache' \
  -H 'Connection: keep-alive' \
  -H 'Content-Type: application/vnd.api+json' \
  -H 'Host: localhost:8080'
```

The response you get back from the API should look like:

```json
{
    "data": [
        {
            "id": "1",
            "type": "components",
            "attributes": {
                "serialNumber": 86756789,
                "reportedVersion": "1.0.0",
                "installDate": "2019-08-20T01:14:14.000+0000",
                "created": "2019-08-20T01:14:24.000+0000",
                "parentComponent": null,
                "name": "HelloWorld",
                "warranty": "2019-07-10T01:14:04.000+0000",
                "modelNumber": 123,
                "type": "COMPONENT_TYPE1",
                "updated": "2019-10-10T17:39:54.000+0000"
            },
            "relationships": {
                "componentAuditHistory": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/1/relationships/componentAuditHistory",
                        "related": "http://localhost:8080/restaurant_assets/components/1/componentAuditHistory"
                    }
                },
                "vendor": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/1/relationships/vendor",
                        "related": "http://localhost:8080/restaurant_assets/components/1/vendor"
                    }
                },
                "restaurant": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/1/relationships/restaurant",
                        "related": "http://localhost:8080/restaurant_assets/components/1/restaurant"
                    }
                },
                "componentGroup": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/1/relationships/componentGroup",
                        "related": "http://localhost:8080/restaurant_assets/components/1/componentGroup"
                    }
                },
                "componentProps": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/1/relationships/componentProps",
                        "related": "http://localhost:8080/restaurant_assets/components/1/componentProps"
                    }
                }
            },
            "links": {
                "self": "http://localhost:8080/restaurant_assets/components/1"
            }
        },
        {
            "id": "2",
            "type": "components",
            "attributes": {
                "serialNumber": 464338,
                "reportedVersion": "v2",
                "installDate": "2019-09-01T04:17:03.000+0000",
                "created": "2019-09-01T04:17:12.000+0000",
                "parentComponent": null,
                "name": "HelloWorld",
                "warranty": "2019-09-30T04:16:51.000+0000",
                "modelNumber": 456,
                "type": "COMPONENT_TYPE2",
                "updated": "2019-09-05T04:17:23.000+0000"
            },
            "relationships": {
                "componentAuditHistory": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/2/relationships/componentAuditHistory",
                        "related": "http://localhost:8080/restaurant_assets/components/2/componentAuditHistory"
                    }
                },
                "vendor": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/2/relationships/vendor",
                        "related": "http://localhost:8080/restaurant_assets/components/2/vendor"
                    }
                },
                "restaurant": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/2/relationships/restaurant",
                        "related": "http://localhost:8080/restaurant_assets/components/2/restaurant"
                    }
                },
                "componentGroup": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/2/relationships/componentGroup",
                        "related": "http://localhost:8080/restaurant_assets/components/2/componentGroup"
                    }
                },
                "componentProps": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/2/relationships/componentProps",
                        "related": "http://localhost:8080/restaurant_assets/components/2/componentProps"
                    }
                }
            },
            "links": {
                "self": "http://localhost:8080/restaurant_assets/components/2"
            }
        },
        {
            "id": "3",
            "type": "components",
            "attributes": {
                "serialNumber": 999222999,
                "reportedVersion": "1.2",
                "installDate": "2019-09-06T10:46:30.000+0000",
                "created": "2019-09-03T10:46:40.000+0000",
                "parentComponent": null,
                "name": "AnotherTestComponent",
                "warranty": "2019-07-02T10:46:23.000+0000",
                "modelNumber": 789,
                "type": "COMPONENT_TYPE2",
                "updated": "2019-09-06T10:46:47.000+0000"
            },
            "relationships": {
                "componentAuditHistory": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/3/relationships/componentAuditHistory",
                        "related": "http://localhost:8080/restaurant_assets/components/3/componentAuditHistory"
                    }
                },
                "vendor": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/3/relationships/vendor",
                        "related": "http://localhost:8080/restaurant_assets/components/3/vendor"
                    }
                },
                "restaurant": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/3/relationships/restaurant",
                        "related": "http://localhost:8080/restaurant_assets/components/3/restaurant"
                    }
                },
                "componentGroup": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/3/relationships/componentGroup",
                        "related": "http://localhost:8080/restaurant_assets/components/3/componentGroup"
                    }
                },
                "componentProps": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/3/relationships/componentProps",
                        "related": "http://localhost:8080/restaurant_assets/components/3/componentProps"
                    }
                }
            },
            "links": {
                "self": "http://localhost:8080/restaurant_assets/components/3"
            }
        },
        {
            "id": "4",
            "type": "components",
            "attributes": {
                "serialNumber": 10905615,
                "reportedVersion": "1.0",
                "installDate": "2019-09-05T02:32:52.000+0000",
                "created": "2019-09-02T02:33:11.000+0000",
                "parentComponent": null,
                "name": "TestComponent",
                "warranty": "2019-09-01T02:32:44.000+0000",
                "modelNumber": 878,
                "type": "COMPONENT_TYPE1",
                "updated": "2019-09-06T02:33:26.000+0000"
            },
            "relationships": {
                "componentAuditHistory": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/4/relationships/componentAuditHistory",
                        "related": "http://localhost:8080/restaurant_assets/components/4/componentAuditHistory"
                    }
                },
                "vendor": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/4/relationships/vendor",
                        "related": "http://localhost:8080/restaurant_assets/components/4/vendor"
                    }
                },
                "restaurant": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/4/relationships/restaurant",
                        "related": "http://localhost:8080/restaurant_assets/components/4/restaurant"
                    }
                },
                "componentGroup": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/4/relationships/componentGroup",
                        "related": "http://localhost:8080/restaurant_assets/components/4/componentGroup"
                    }
                },
                "componentProps": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/4/relationships/componentProps",
                        "related": "http://localhost:8080/restaurant_assets/components/4/componentProps"
                    }
                }
            },
            "links": {
                "self": "http://localhost:8080/restaurant_assets/components/4"
            }
        },
        {
            "id": "5",
            "type": "components",
            "attributes": {
                "serialNumber": 756632839,
                "reportedVersion": "1.0",
                "installDate": "2019-09-03T02:38:09.000+0000",
                "created": "2019-09-01T02:38:35.000+0000",
                "parentComponent": null,
                "name": "TestComponent",
                "warranty": "2019-06-03T02:38:01.000+0000",
                "modelNumber": 254,
                "type": "COMPONENT_TYPE1",
                "updated": "2019-09-06T02:38:43.000+0000"
            },
            "relationships": {
                "componentAuditHistory": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/5/relationships/componentAuditHistory",
                        "related": "http://localhost:8080/restaurant_assets/components/5/componentAuditHistory"
                    }
                },
                "vendor": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/5/relationships/vendor",
                        "related": "http://localhost:8080/restaurant_assets/components/5/vendor"
                    }
                },
                "restaurant": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/5/relationships/restaurant",
                        "related": "http://localhost:8080/restaurant_assets/components/5/restaurant"
                    }
                },
                "componentGroup": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/5/relationships/componentGroup",
                        "related": "http://localhost:8080/restaurant_assets/components/5/componentGroup"
                    }
                },
                "componentProps": {
                    "links": {
                        "self": "http://localhost:8080/restaurant_assets/components/5/relationships/componentProps",
                        "related": "http://localhost:8080/restaurant_assets/components/5/componentProps"
                    }
                }
            },
            "links": {
                "self": "http://localhost:8080/restaurant_assets/components/5"
            }
        }
    ],
    "links": {
        "first": "http://localhost:8080/restaurant_assets/components?page[limit]=20",
        "last": "http://localhost:8080/restaurant_assets/components?page[limit]=20"
    },
    "meta": {
        "totalResourceCount": 5
    }
}
```

9. Check the status of the container and its ID that you just built by following command: `docker ps -a`
10. If needed to push it to your ECR registry, tag the Docker image by following command: `docker tag {Container ID}:latest {ECR Registry Address}:{latest or Custom Tag}`
11. If needed, push the image to your ECR registry by following command: `docker push {ECR Registry Address}:{latest or Custom Tag}`
12. To stop the container: `docker stop {Container ID}`
13. To remove the container: `docker rm {Container ID}`
14. To remove the image: `docker rmi -f {Image ID}`

## How to set up the development environment locally
1. Checkout the source code from the repository to the local filesystem
2. If not installed already, install an IDE (integrated development environment) for Java development. Some suggestions are Spring Tool Suite or IntelliJ
3. If not installed already, install Maven, which is the build tool for this project
4. Import the project and its source code into the IDE as an existing Maven project
5. If you want the service to use a local instance of MySql database, install and set up the MySql server locally to get the local database ready for the service to connect to. If needed, follow the section below, "How to set up the Bre Restaurant Assets database locally" to understand how to do this
6. In the source code, navigate to the `application.properties` file on `/src/main/resources` and change the properties, `spring.datasource.url`, `spring.datasource.username`, and `spring.datasource.password` to configure the source database, if needed.
7. You can build the application using provided Maven features in your IDE or using the command line. At the root of the source code, the command for Maven build is `mvn clean package`
8. You can start the built application (.jar file) using provided feratures in your IDE or using the command line. In `/target`, run the command, `java -jar JAR_FILE_NAME.jar`
9. Verify that the application has been started successfully and is running by its healthcheck endpoint, `http://localhost:8080/actuator/health`

## How to set up the database locally
1. Install the MySql server
2. Create and start a new MySql database server
3. Create a new database; its name can be referred in the `Spring.datasource.url` property of `/src/main/resource/application.properties` file
4. If you want the service to automatically generate the database objects, such as tables, make sure to have, `spring.jpa.hibernate.ddl-auto=update` in the same `application.properties` file
5. Run the dbScript.sql in database to get the required views and triggers

# Pipeline Breakdown

**Container Builder Pipeline**

* Uses our `build-tools` container to build a Dockerfile and push it to ECR/Artifactory
* Docker image is first built and tagged with the registry/application name
* The pipeline checks release and replace version tags for the image. If the image is not properly tagged, the pipeline will error to ensure versioning standards are kept.
* Before pushing the docker image to the registry the pipeline will check the type of branch the dockerfile is coming from `(master, feature, hotfix)` and tag the image accordingly. Tagging will be skipped if branch type is does not match any of the types allowed. [for hotfix and feature branches jira ticket numbers will be included in the tag as well]
* Once pushed to the Docker image registry, the unneeded images are removed.
* Pipeline checks if this build is a release build or a master/feature/hotfix build. Depending on the build type the pipeline will send a new release message or a regular build message to the respective topic.


# Pipeline Guide

**Confluence**: https://us-confluence.mcd.com/pages/viewpage.action?pageId=140347235

# Development Guidelines

**Confluence**: https://us-confluence.mcd.com/pages/viewpage.action?spaceKey=BREP&title=Development+Guidelines
