# # Lambda security Group

# resource "aws_security_group" "SQS_lambda_sg" {
#   name_prefix = "${var.tags["Name"]}-SQS-LAMBDA-SG"
#   vpc_id      = var.vpc_id
#   description = "Security group used for the ${var.tags["Name"]}-SQS(Managed by Terraform)"

#   egress {
#     from_port   = 0
#     to_port     = 0
#     protocol    = "-1"
#     cidr_blocks = ["0.0.0.0/0"]
#   }

#   tags = var.tags

#   timeouts {
#     delete = "40m"
#   }
# }

# lambda 
resource "aws_lambda_function" "SQS-creation-lambda" {
  function_name    = "${var.tags["Name"]}-SQS-LAMBDA"
  role             = aws_iam_role.SQS_lambda_role.arn
  handler          = "main.lambda_handler"
  runtime          = "python3.7"
  timeout          = 300
  filename         = data.archive_file.lambda_zip.output_path
  source_code_hash = data.archive_file.lambda_zip.output_base64sha256
  tags             = var.tags
  environment {
    variables = {
      REGION      = var.region
      ENVIRONMENT = upper(var.environment)
      kms_key_id = data.aws_kms_key.kms_sqs.key_id
      marketName = "US"
      configManagementServiceUrl = "https://config-management.api.${var.environment}.bre.mcd.com"
      assetServiceUrl = "https://asset.api.${var.environment}.bre.mcd.com"
      SNS_TOPIC_ARN = "arn:aws:sns:us-east-1:${data.aws_caller_identity.current.account_id}:gitops-onboarding-sns"
    }
  }
}

resource "aws_iam_role" "SQS_lambda_role" {
  name               = "BRED-ONBOARD-SQS-LAMBDA"
  assume_role_policy = data.aws_iam_policy_document.assume_role_policy.json
}

resource "aws_iam_role_policy_attachment" "AWSLambdaBasicExecutionRole_SQS" {
  role       = aws_iam_role.SQS_lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole"
}

# resource "aws_iam_role_policy_attachment" "invoke_services_apis_policy_arn" {
#   role       = aws_iam_role.SQS_lambda_role.name
#   policy_arn = var.invoke_services_apis_policy_arn
# }

resource "aws_iam_policy" "sqs-lambda-policy" {
  name        = "SQS-lambda-policy"
  path        = "/"
  description = "IAM policy for SQS-lambda-Onboarding"
  policy      = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "execute-api:Invoke"
      ],
      "Effect": "Allow",
      "Resource": [
        "arn:aws:execute-api:*:*:*"
      ]
    },
    {
      "Sid": "S3BucketAccess",
      "Effect": "Allow",
      "Action": [
        "s3:PutObject",
        "s3:GetObject",
        "s3:DeleteObject",
        "s3:ListBucket",
        "s3:PutObjectAcl",
        "s3:GetObjectAcl",
        "s3:PutObjectVersionAcl",
        "s3:GetObjectVersionAcl"
      ],
      "Resource": "*"
    },
    {
      "Sid": "SQSPermissions",
      "Effect": "Allow",
      "Action": [
        "sqs:*"
      ],
      "Resource": "arn:aws:sqs:*:*:*"
    },
    {
      "Sid": "SNSPermissions",
      "Effect": "Allow",
      "Action": [
        "sns:Publish"
      ],
      "Resource": "*"
    },
    {
      "Effect": "Allow",
      "Action": [
        "sqs:ReceiveMessage",
        "sqs:DeleteMessage",
        "sqs:GetQueueAttributes",
        "logs:CreateLogGroup",
        "logs:CreateLogStream",
        "logs:PutLogEvents"
      ],
      "Resource": "*"
    },
    {
      "Effect": "Allow",
      "Action": [
        "secretsmanager:GetResourcePolicy",
        "secretsmanager:GetSecretValue",
        "secretsmanager:DescribeSecret",
        "secretsmanager:ListSecretVersionIds",
        "lambda:ListFunctions"
      ],
      "Resource": "*"
    }
  ]
}
EOF
}


resource "aws_iam_role_policy_attachment" "sqs-lambda-policy-attachment" {
  role       = aws_iam_role.SQS_lambda_role.name
  policy_arn = aws_iam_policy.sqs-lambda-policy.arn
}


resource "aws_iam_role_policy_attachment" "AmazonAPIGatewayInvokeFullAccess_sqs" {
  role       = aws_iam_role.SQS_lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/AmazonAPIGatewayInvokeFullAccess"
}



# resource "aws_lambda_permission" "iam_apigw_sqs_lambda" {
#    statement_id  = "AllowAPIIAMGatewayInvoke"
#    action        = "lambda:InvokeFunction"
#    function_name = aws_lambda_function.SQS-creation-lambda.function_name
#    principal     = "apigateway.amazonaws.com"

#    # The "/*/*" portion grants access from any method on any resource
#    # within the API Gateway REST API.
#    source_arn = "${data.aws_api_gateway_rest_api.asset_iam_api.execution_arn}/*/*"
# }


# # # For AD Asset API GW

# resource "aws_lambda_permission" "ad_apigw_sqs_lambda" {
#    statement_id  = "AllowAPIADGatewayInvoke"
#    action        = "lambda:InvokeFunction"
#    function_name = aws_lambda_function.SQS-creation-lambda.function_name
#    principal     = "apigateway.amazonaws.com"

#    # The "/*/*" portion grants access from any method on any resource
#    # within the API Gateway REST API.
#    source_arn = "${data.aws_api_gateway_rest_api.asset_ad_api.execution_arn}/*/*"
# }
