data "aws_subnets" "private" {
  filter {
    name = "vpc-id"
    values = [var.vpc_id]
  }

  tags = {
    Name = "*${var.worker_subnet_type}*"
  }
}

data "aws_caller_identity" "current" {}

#    Onboard SQS lambda

data "archive_file" "lambda_zip" {
  type        = "zip"
  source_dir  = "../src"
  output_path = "${path.module}/lambda/lambda.zip"
}

data "aws_iam_policy_document" "assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]
    effect  = "Allow"
    principals {
      type        = "Service"
      identifiers = ["lambda.amazonaws.com"]
    }
  }
}

data "aws_api_gateway_rest_api" "asset_iam_api" {
  name = var.asset_iam_api_gateway_name
}

data "aws_api_gateway_rest_api" "asset_ad_api" {
  name = var.asset_ad_api_gateway_name
}

data "aws_kms_key" "kms_sqs" {
  key_id = data.aws_kms_alias.my_alias.target_key_id
}

data "aws_kms_alias" "my_alias" {
  name = "alias/bre"
}

