# Pipeline Breakdown

## **Description**
GitOps Onboarding lambda can perform the following actions on GitOps environment specific repository:
	- Onboarding a new restaurant 
	- Offboarding an existing restaurant
	- Onboarding products to an existing restaurant
	- Offboarding products from an existing restaurant

GitOps repository naming convention:
	"brep-gitops-<environment>-<marketName>-<regionName>"
	Example: brep-gitops-dev-us-chicago

Refer confluence page for more details: https://us-confluence.mcd.com/x/fVt0Dw

## **Usage**

Payload to manually test lambda:
If you want to test the process to onboard a new restaurant/cluster - 
```
 {
	"RestaurantNumber": {
	"Type": "String",
	"Value": "[\"55\"]"
	},
	"action": {
	"Type": "String",
	"Value": "OnboardCluster"
	},
	"marketName": {
	"Type": "String",
	"Value": "US"
	},
	"productList": {
	"Type": "String",
	"Value": "[\"brecm\", \"infrastructure\", \"imagecache\", \"bred\", \"evd\", \"aidt\", \"iot\", \"menu\"]"
	}
}
```
If you want to test the process to offboard an existing restaurant/cluster - 
```
 {
	"RestaurantNumber": {
	"Type": "String",
	"Value": "[\"55\"]"
	},
	"action": {
	"Type": "String",
	"Value": "OffboardCluster"
	},
	"marketName": {
	"Type": "String",
	"Value": "US"
	}
}
```
If you want to test the process to onboard products on an existing restaurant/cluster - 
```
 {
	"RestaurantNumber": {
	"Type": "String",
	"Value": "[\"55\"]"
	},
	"action": {
	"Type": "String",
	"Value": "OnboardProduct"
	},
	"marketName": {
	"Type": "String",
	"Value": "US"
	},
	"productList": {
	"Type": "String",
	"Value": "[\"aidt\", \"iot\", \"menu\"]"
	}
}
```
If you want to test the process to offboard products from an existing restaurant/cluster- 
```
 {
	"RestaurantNumber": {
	"Type": "String",
	"Value": "[\"55\"]"
	},
	"action": {
	"Type": "String",
	"Value": "OffboardProduct"
	},
	"marketName": {
	"Type": "String",
	"Value": "US"
	},
	"productList": {
	"Type": "String",
	"Value": "[\"iot\", \"menu\"]"
	}
}
```

## **Additional Notes**
Dev - deployment should be done through feature/master branch
Int/Stage - deployment should only be done through master branch
Production - Cut the release tag and deployment should be done only though tags pipeline

Update Changelog file with the exact functionality enhancement done on the latest release tag.

# GitOps Development Guide

**Confluence**: https://us-confluence.mcd.com/display/BTP/GitOps%3A+Development+standards+and+higher-env+release


**Terraform Pipeline**

* Uses our `build-tools` container to run the terraform script.
* User selects name of config tfvars file and Terraform action (plan, apply, destroy) before the pipeline is kicked off. 
* Pipeline does a GIT checkout of the Terraform repo.
* Pipeline will run the init.sh script to initialize Terraform.
* Regardless of Terraform action selected, all pipelines will run a `terraform validate` command.
* If user selects a Terraform action of `plan` the pipeline will only run the `terraform plan` command and then exit the pipeline.
* If user selects a Terraform action of `apply` the pipeline will run the `terraform apply` command with an auto approve, and then exit the pipeline.
* If user selects a Terraform action of `destroy` the pipeline will run the `terraform destroy` command with an auto approve, and then exit the pipeline.

# Pipeline Guide

**Confluence**: https://us-confluence.mcd.com/pages/viewpage.action?pageId=140347235

# Development Guidelines

**Confluence**: https://us-confluence.mcd.com/pages/viewpage.action?spaceKey=BREP&title=Development+Guidelines
