export function arraysAreEqual(_arr1, _arr2) {
  if (!compareArrays(_arr1, _arr2)) {
    return false;
  }
  var arr1 = _arr1.concat().sort();
  var arr2 = _arr2.concat().sort();
  for (var i = 0; i < arr1.length; i++) {
    if (arr1[i] !== arr2[i]) return false;
  }
  return true;
}
export function checkIfArray(_arr1) {
  if (!(_arr1 instanceof Array)) {
    return false;
  }
  return true;
}
export function compareArrays(_arr1, _arr2) {
  if (
    !checkIfArray(_arr1) ||
    !checkIfArray(_arr2) ||
    !checkLengthOfArray(_arr1, _arr2)
  ) {
    return false;
  }
  return true;
}

export function checkLengthOfArray(_arr1, _arr2) {
  return _arr1.length === _arr2.length;
}

/**
 * Convert number to two digit string (ex. 2 -> 02, 5 -> 05)
 * @param n number
 * @returns number string in two digits
 */
export function getTwoDigitForm(n: number) {
  return n.toLocaleString("en-US", {
    minimumIntegerDigits: 2,
    useGrouping: false
  });
}

/**
 * Convert date params to array
 * @param values array
 * @returns date as array
 */
export function datesToArray(...values) {
  const filtered = values.filter(x => !!x);
  return filtered.length === 0
    ? undefined
    : filtered.map(x => Array.isArray(x) ? x : [x]).reduce((acc, x) => acc.concat(x), [])
}
