import { NgModule, ModuleWithProviders } from '@angular/core';
import { CoreModule } from '@bref/core';
import { SolutionsNavButtonComponent } from './components/solutions-nav-button/solutions-nav-button.component';
import { SolutionsEnvService } from './solutions-env.service';

@NgModule({
  declarations: [ SolutionsNavButtonComponent ],
  imports: [
    CoreModule
  ],
  exports: [ SolutionsNavButtonComponent ]
})
export class StandaloneSolutionsComponentsModule { 
  public static forRoot(environment: any): ModuleWithProviders<StandaloneSolutionsComponentsModule> {
    return {
           ngModule: StandaloneSolutionsComponentsModule,
           providers: [
               {
                   provide: 'env',
                   useValue: environment
               },
               SolutionsEnvService
           ]
       };
 }
}
