import { NgModule } from "@angular/core";
import { CoreModule } from "@bref/core";
import { MatCheckboxModule } from "@angular/material/checkbox";
import { DevicesListComponent } from "./pages/devices-list/devices-list.component";
import { RouterModule } from "@angular/router";
import { ComponentStatusPillComponent } from "./components/component-status-pill/component-status-pill.component";
import { DeviceDetailsComponent } from "./pages/device-details/device-details.component";
import { DashboardComponent } from "./pages/dashboard/dashboard.component";
import { BundlesComponent } from "./pages/bundles/bundles.component";
import { AssetsListComponent } from "./pages/assets-list/assets-list.component";
import { SolutionsNavigationBarComponent } from "./components/solutions-navigation-bar/solutions-navigation-bar.component";
import { DeviceDetailsEditComponent } from "./pages/device-details-edit/device-details-edit.component";
import { OnboardingDialogComponent } from "./components/onboarding-dialog/onboarding-dialog.component";
import { CertificatesListComponent } from "./pages/certificates-list/certificates-list.component";
import { CertificateStatusPillComponent } from "./components/certificate-status-pill/certificate-status-pill.component";
import { ReactiveFormsModule } from "@angular/forms";
import { EmptyStateSolutionsComponent } from "./components/empty-state-solutions/empty-state-solutions.component";
import { DeviceOnboardingComponent } from "./pages/device-onboarding/device-onboarding.component";
import { FullscreenDialogComponent } from "./components/fullscreen-dialog/fullscreen-dialog.component";
import { AddDeviceComponent } from "./components/add-device/add-device.component";
import { StoresDevicesComponent } from "./components/stores-devices/stores-devices.component";
import { StoreDeviceComponent } from "./components/store-device/store-device.component";
import { StoreSummaryComponent } from "./components/store-summary/store-summary.component";
import { OnboardingVendorDetailsComponent } from "./components/onboarding-vendor-details/onboarding-vendor-details.component";
import { AccordionModule } from "primeng/accordion";
import { DeviceActivityLogComponent } from "./components/device-activity-log/device-activity-log.component";
import { FormsModule } from "@angular/forms";
import { ConfirmOnboardingPopupComponent } from "./components/confirm-onboarding-popup/confirm-onboarding-popup.component";
import { AddVendorDeviceTypeComponent } from "./components/onboard-vendor/add-vendor-device-type/add-vendor-device-type.component";
import { AddVendorConfirmationSummaryComponent } from "./components/onboard-vendor/add-vendor-confirmation-summary/add-vendor-confirmation-summary.component";
import { ContactDetailsCardComponent } from "./components/common/contact-details-card/contact-details-card.component";
import { DeviceTypeDetailsComponent } from "./components/common/device-type-details/device-type-details.component";
import { ConfirmVendorOnboardingPopupComponent } from "./components/onboard-vendor/confirm-vendor-onboarding-popup/confirm-vendor-onboarding-popup.component";
import { VendorDetailsComponent } from "./pages/vendor-details/vendor-details.component";
import { VendorListComponent } from "./pages/vendor-list/vendor-list.component";
import { VendorOnboardingComponent } from "./pages/vendor-onboarding/vendor-onboarding.component";
import { AddVendorComponent } from "./components/onboard-vendor/add-vendor/add-vendor.component";
import { AddDeviceTypeComponent } from "./pages/add-device-type/add-device-type.component";
import { AddDeviceTypeSummaryComponent } from "./components/add-device-type-summary/add-device-type-summary.component";
import { ConfirmCloseDialogComponent } from "./components/confirm-close-dialog/confirm-close-dialog.component";
import { ConfirmEditVendorPopupComponent } from "./components/onboard-vendor/confirm-edit-vendor-popup/confirm-edit-vendor-popup.component";
@NgModule({
  declarations: [
    DevicesListComponent,
    ComponentStatusPillComponent,
    DeviceDetailsComponent,
    DashboardComponent,
    BundlesComponent,
    AssetsListComponent,
    SolutionsNavigationBarComponent,
    DeviceDetailsEditComponent,
    OnboardingDialogComponent,
    CertificatesListComponent,
    CertificateStatusPillComponent,
    EmptyStateSolutionsComponent,
    DeviceOnboardingComponent,
    FullscreenDialogComponent,
    AddDeviceComponent,
    StoresDevicesComponent,
    StoreDeviceComponent,
    OnboardingVendorDetailsComponent,
    StoreSummaryComponent,
    DeviceActivityLogComponent,
    ConfirmOnboardingPopupComponent,
    VendorDetailsComponent,
    VendorListComponent,
    VendorOnboardingComponent,
    AddVendorComponent,
    AddVendorDeviceTypeComponent,
    AddVendorConfirmationSummaryComponent,
    ContactDetailsCardComponent,
    DeviceTypeDetailsComponent,
    ConfirmVendorOnboardingPopupComponent,
    AddDeviceTypeComponent,
    AddDeviceTypeSummaryComponent,
    ConfirmCloseDialogComponent,
    ConfirmEditVendorPopupComponent,
  ],
  imports: [
    CoreModule,
    ReactiveFormsModule,
    MatCheckboxModule,
    RouterModule.forChild([
      {
        path: "",
        pathMatch: "full",
        redirectTo: "devices",
      },
      {
        path: "devices",
        pathMatch: "prefix",
        component: DevicesListComponent,
        data: {
          breadcrumb: "Devices",
        },
      },
      {
        path: "devices/:deviceId",
        pathMatch: "prefix",
        component: DeviceDetailsComponent,
      },
      {
        path: "devices/:deviceId/edit",
        pathMatch: "prefix",
        component: DeviceDetailsEditComponent,
      },
      /* uncomment when Solutions Dashboard page is needed
      {
        path: 'dashboard',
        pathMatch: 'prefix',
        component: DashboardComponent,
        data: {
          breadcrumb: 'Solutions Dashboard'
        }
      },
      */
      /* uncomment when Bundles page is needed
      {
        path: 'bundles',
        pathMatch: 'prefix',
        component: BundlesComponent,
        data: {
          breadcrumb: 'Bundles'
        }
      },
      */
      {
        path: "assets",
        pathMatch: "prefix",
        component: AssetsListComponent,
        data: {
          breadcrumb: "Software & Assets",
        },
      },
      {
        path: "certificates",
        pathMatch: "prefix",
        component: CertificatesListComponent,
        data: {
          breadcrumb: "Certificates",
        },
      },
      {
        path: 'certificates?storeName=":devicestore"&page=1&pageSize=25&sortBy=expiry&sortDirection=asc',
        pathMatch: "prefix",
        component: CertificatesListComponent,
        data: {
          breadcrumb: "Certificates",
        },
      },
      {
        path: "vendors",
        pathMatch: "full",
        component: VendorListComponent,
        data: {
          breadcrumb: "vendors",
        },
      },
      {
        path: "vendors/:vendorId",
        pathMatch: "prefix",
        component: VendorDetailsComponent,
      },
    ]),
    AccordionModule,
    FormsModule,
  ],
  providers: [],
})
export class SolutionsModule {}
