import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from "rxjs";
import { vendorDetails, vendorTypeDetails } from '../interfaces/vendor.interface';
import { SolutionsEnvService } from '../solutions-env.service';
import { ApiService } from '@bref/core';
import { AddDeviceTypeVendorDetails } from './add-data-type.service';
import * as onBoardVendroConstants from '../constants/onboard-vendor-constants';
@Injectable({
    providedIn: 'root'
})

export class SelectedVendorDataService {
    vendorData;
    private onVendorOnboardSuccessSource = new BehaviorSubject(false);
    onboardSuccess = this.onVendorOnboardSuccessSource.asObservable();

    private editSuccessSubject = new BehaviorSubject(false);
    editSuccess = this.editSuccessSubject.asObservable();

    constructor(private api: ApiService, private addDeviceTypeVendorDetails: AddDeviceTypeVendorDetails) {
        this.getAddVendorDeviceTypeObject().subscribe(value => this.vendorData = value);
    }

    private addvendorObj = new BehaviorSubject<vendorDetails[]>([]);
    addDevice = this.addvendorObj.asObservable();


    private addvendorDeviceTypeObj = new BehaviorSubject<vendorTypeDetails[]>([]);
    addDeviceType = this.addvendorDeviceTypeObj.asObservable();

    /**
* Get the auth token to send along with the header of post request.
*/
    private getBackendBaseHeaders() {
        return {
            Authorization: "Bearer " + SolutionsEnvService.get('msalIDToken')
        };
    }

    /**
     * Function updated the service with data sent
     * @param data to be updated
     */
    setAddVendor(data: vendorDetails[]) {
        this.addvendorObj.next(data);
    }

    /**
     * Returns the update servic object
     * @returns observable
     */
    getAddVendorObject(): Observable<any> {
        return this.addvendorObj.asObservable();
    }

    /**
   * Function updated the service with data sent
   * @param data to be updated
   */
    setAddVendorDeviceType(data: vendorTypeDetails[]) {
        this.addvendorDeviceTypeObj.next(data);
    }

    /**
     * Returns the update servic object
     * @returns observable
     */
    getAddVendorDeviceTypeObject(): Observable<any> {
        return this.addvendorDeviceTypeObj.asObservable();
    }

    /**
     * Checks if the entered data is valid and returns accordingly
     * @returns boolean
     */
    isAnyNullOnAddVendorObject(): boolean {
        let result: boolean = false;
        this.getAddVendorObject().subscribe((response) => {
            if (response !== null && response != undefined && response.length > 0) {
                response.forEach(e => {
                    if (result) {
                        return;
                    }
                    if (!e.vendorName || !(e.contactDetails?.length)) {
                        result = true;
                    }
                    e.contactDetails.forEach(
                        (ele) => {
                            const isPhoneValid = onBoardVendroConstants.PHONE_REG.test(ele.phone);
                            const isEmailValid = onBoardVendroConstants.EMAIL_REG.test(ele.email);
                            if ( ele.name && isPhoneValid && isEmailValid) {
                                result = false;
                            } else if( ele.name && isPhoneValid && (ele.email === '' || ele.email === null)){
                                result = false;
                            } else if( ele.name && isEmailValid && (ele.phone === '' || ele.phone === null)){
                                result = false;
                            } else {
                                return result = true;
                            }
                        }
                    )
                });
            } else {
                result = true;
            }
        });
        return result;
    }

    isAnyNullOnAddVendorTyepObject(): boolean {
        let result: boolean = false;
        this.getAddVendorDeviceTypeObject().subscribe((response) => {
            if (response !== null && response != undefined && response.length > 0) {
                response.forEach(e => {
                    if (result) {
                        return;
                    }
                    if (!e.deviceTypeCategory || !e.deviceType) {
                        result = true;
                    }
                });
            } else {
                result = true;
            }
        });
        return result;
    }

    /**
 * onboarding of Vendor
 */
    public async onBoardVendor() {
        const payload = this.generatePayload('onboardVendor');
        const apiEndpoint = SolutionsEnvService.get('vendorOnboardingUrl');
        const response = await this.api.post<any>(`${apiEndpoint}`, payload,
            null,
            null, this.getBackendBaseHeaders());
        this.setVendorOnboardSuccess(true);
        return response;
    }

    public async addVendorDeviceType() {
        const payload = this.generatePayload('deviceType');
        const apiEndpoint = SolutionsEnvService.get('vendorOnboardingUrl');
        const response = await this.api.post<any>(`${apiEndpoint}`, payload,
            null,
            null, this.getBackendBaseHeaders());
        this.setEditSuccess(true);
        return response;
    }

    public async editVendor(vendorid) {
        const payload = this.generatePayload('editvendor');
        payload.vendorId = vendorid;
        const apiEndpoint = SolutionsEnvService.get('vendorOnboardingUrl');
        const response = await this.api.post<any>(`${apiEndpoint}`, payload,
            null,
            null, this.getBackendBaseHeaders());
        this.setEditSuccess(true);
        return response;
    }


    generatePayload(type) {
        let vendorDetails, vendorType;
        this.getAddVendorObject().subscribe(value => {
            vendorDetails = value[0];
        });
        vendorType = this.vendorData.map(item => {
            let deviceTypeAttributes = item.deviceTypeAttributes.map(item => {
                if (item.type === 'New') {
                    item.type = 'string';
                } 
                 if(item.name === 'IP Address') {
                    item.name = 'ipAddress'
                } 
                 if(item.name === 'MAC Address') {
                    item.name = 'macAddress'
                } 
                 if(item.name === 'Lane Number') {
                    item.name = 'laneNumber'
                }
                return item
            });
            return {
                "deviceType": item.deviceType,
                "deviceFlag": item.deviceFlag,
                "deviceTypeAttributes": deviceTypeAttributes.filter(item => item.type === 'string'),
                "deviceAbbreviation": item.deviceAbbreviation
            }
        });
        if (type === 'onboardVendor') {
            return {
                "action": 'createVendor',
                "vendorName": vendorDetails?.vendorName,
                "notes": vendorDetails?.vendorNotes,
                "contacts": vendorDetails?.contactDetails,
                "devices": vendorType
            }
        } else if (type === 'deviceType') {
            this.addDeviceTypeVendorDetails.getAddVendorObject().subscribe(data => {
                vendorDetails = data;
            });
            return {
                "action": 'addDeviceType',
                "vendorId": vendorDetails?.data.id,
                "devices": vendorType
            }
        } else if (type === 'editvendor') {
            return {
                "action": 'editVendor',
                "vendorId": vendorDetails?.id,
                "notes": vendorDetails?.vendorNotes,
                "contacts": vendorDetails?.contactDetails,
            }
        }

    }

    /**
 *
 * @param popupStatus Boolean
 * This function sets the status of onboardSuccess when onboarding is successfully intiated
 */
    setVendorOnboardSuccess(popupStatus: boolean) {
        this.onVendorOnboardSuccessSource.next(popupStatus);
    }

    /**
  *
  * @param popupStatus Boolean
  * This function sets the status when edit is successfull.
  */
    setEditSuccess(popupStatus: boolean) {

        this.editSuccessSubject.next(popupStatus);

    }
}