import {Injectable} from '@angular/core';
import {BehaviorSubject,Observable} from "rxjs";
import { AddStoreSource } from '../interfaces/device-onboarding-api.interface';

@Injectable({
    providedIn: 'root'
})

export class SelectedDeviceDataService {
    constructor(){ }

    private addStoreObs = new BehaviorSubject<AddStoreSource[]>([]);
    addStore = this.addStoreObs.asObservable();

    private errorStatus = new BehaviorSubject([]);
    errorState = this.errorStatus.asObservable();

    setAddStoreObject(data: AddStoreSource[]) {
        this.addStoreObs.next(data); 
    }

    getAddStoreObject(): Observable<any> {
        return this.addStoreObs.asObservable();
    }

    /**
     * @param data : Are there any active error fields
     * set errorStatus based on param recieved.
     */
    setErrorState(data){
        this.errorStatus.next(data); 
    }

     /**
     *
     * get errorStatus.
     * This is subscribed in device onboarding page to enable or disable 
     * the next button based on field validation.
     */
    getErrorState(){
        return this.errorStatus.asObservable();
    }

    isAnyNullOnDeviceObject() : boolean{
        let result : boolean = false;
        this.getAddStoreObject().subscribe((response) => {
            if(response !== null && response != undefined && response.length > 0) {
            response.forEach(e => {
                if (result) {
                    return;
                }
                if (!e.store || !(e.properties?.length)) {
                    result = true;
                }
                e.properties.forEach(
                    ele => {
                        if (
                            !ele.vendor || 
                            !ele.dName || 
                            !ele.dLane ||
                            !ele.dAngle ||
                            !ele.modelNo ||
                            !ele.install ||
                            !ele.warranty ||
                            (ele.isIpAvailable && !ele.ip) ||
                            (ele.isMacAvailable && !ele.mac) ||
                            (ele.isLaneAvailable && !ele.lane) ||
                            !ele.sNo ||
                            !ele.unitNo ||
                            !ele.firmware
                        ) {
                            result = true;
                        }
                    }
                )
            });
        }else {
            result = true;
        }
        });
        return result;
    }
}