import { FilterLikeTerm } from "../interfaces/component-filters.interface";
import { TestBed } from '@angular/core/testing';
import { CoreModule, ApiService } from '@bref/core';
import { RestaurantsApiService } from './restaurants-api.service';

const get = jest.fn((url): any => ({
    "data": [
        {
            "id": "1",
            "attributes": {
                "name": "fryer",
                "modelNumber": 606,
                "type": "GREENGRASS_DEVICE",
                "serialNumber": 123,
                "warranty": "the_warranty"
            },
            "relationships": {
                "restaurant": { "data": { "id": "1" } },
                "vendor": { "data": { "id": "1" } }
            }
        }
    ],
    "included": [
        {
            "id": "2",
            "type": "component_props",
            "attributes": { "propertyName": "deviceIP", "propertyValue": "xyz" }
        },
        {
            "id": "2",
            "type": "restaurants",
            "attributes": { "name": "some restaurant" },
        },
        {
            "id": "1",
            "type": "component_props",
            "attributes": { "propertyName": "deviceIP", "propertyValue": "foobar" }
        },
        {
            "id": "1",
            "type": "restaurants",
            "attributes": { "name": "McDonald's Global Menu Restaurant (HQ)" },
            "relationships": { "market": { "data": { "id": "1" } } }
        },
        {
            "id": "1",
            "type": "vendors",
            "attributes": { "name": "some vendor" },
        },
        {
            "id": "1",
            "type": "markets",
            "attributes": { "name": "some market" },
        }
    ],
    "meta": {
        "totalResourceCount": 11
    }
}));

class ApiServiceMock {
    async get(url) {
        return get(url);
    }
}

xdescribe('RestaurantsApiService', () => {
    let service: RestaurantsApiService;

    beforeEach(() => {
        TestBed.configureTestingModule({
            imports: [CoreModule],
            providers: [
                { provide: ApiService, useValue: new ApiServiceMock() }
            ]
        });
        service = TestBed.inject(RestaurantsApiService);
    });
    afterEach(() => {
        get.mockClear();
    });

    it('should be created', () => {
        expect(service).toBeTruthy();
    });

    it('should properly request restaurants on getRestaurants by name', async () => {
        get.mockReturnValueOnce({
            "data": [
                {
                    "id": "1",
                    "type": "restaurants",
                    "attributes": {
                        "created": "2019-08-21T03:20:58.000+0000",
                        "name": "McDonald's Global Menu Restaurant (HQ)",
                        "updated": "2019-11-18T22:57:50.000+0000"
                    },
                    "relationships": {
                        "market": {
                            "data": {
                                "id": "1"
                            },
                            "links": {
                                "self": "https://asset-service.bre.mcd.com/restaurant_assets/restaurants/1/relationships/market",
                                "related": "https://asset-service.bre.mcd.com/restaurant_assets/restaurants/1/market"
                            }
                        },
                        "components": {
                            "links": {
                                "self": "https://asset-service.bre.mcd.com/restaurant_assets/restaurants/1/relationships/components",
                                "related": "https://asset-service.bre.mcd.com/restaurant_assets/restaurants/1/components"
                            }
                        },
                        "ownerOperator": {
                            "links": {
                                "self": "https://asset-service.bre.mcd.com/restaurant_assets/restaurants/1/relationships/ownerOperator",
                                "related": "https://asset-service.bre.mcd.com/restaurant_assets/restaurants/1/ownerOperator"
                            }
                        }
                    },
                    "links": {
                        "self": "https://asset-service.bre.mcd.com/restaurant_assets/restaurants/1"
                    }
                }
            ],
            "links": {
                "first": "https://asset-service.bre.mcd.com/restaurant_assets/restaurants?page[limit]=20&filter[name][LIKE]=%25global%25",
                "last": "https://asset-service.bre.mcd.com/restaurant_assets/restaurants?page[limit]=20&filter[name][LIKE]=%25global%25"
            },
            "meta": {
                "totalResourceCount": 1
            },
            "included": [
                {
                    "id": "1",
                    "type": "markets",
                    "attributes": { "name": "some market" },
                }
            ]
        })
        const restaurants = await service.searchRestaurants('global', FilterLikeTerm.name);

        const urlParams = new URLSearchParams({
            sort: 'name,id',
            'filter[name][like]': '%global%'
        });
        expect(get).toHaveBeenCalledWith(`https://asset-service.bre.mcd.com/restaurant_assets/restaurants?${urlParams.toString()}`)
        expect(restaurants).toEqual([
            {
                id: '1',
                name: 'McDonald\'s Global Menu Restaurant (HQ)',
                marketName: 'some market'
            }
        ])
    });
});