import { TestBed } from '@angular/core/testing';
import { ApiService, CoreModule } from '@bref/core';
import { OnboardingApiService } from './onboarding-api.service';

const post = jest.fn((url, body): any => ({
    "executionArn": 'test',
    "startDate": 1
  }));

class ApiServiceMock {
    async post(url, body) {
      return post(url, body);
    }
}

xdescribe('OnboardingApiService', () => {
let service: OnboardingApiService;

    beforeEach(() => {
        TestBed.configureTestingModule({
        imports: [CoreModule],
        providers: [
            { provide: ApiService, useValue: new ApiServiceMock() }
        ]
        });
        service = TestBed.inject(OnboardingApiService);
    });
    afterEach(() => {
        post.mockClear();
    });

    it('should be created', () => {
        expect(service).toBeTruthy();
    });

    it('should properly send device info to the Onboarding API on addNewDevice', async () => {
        const mockDate = new Date();
        const mockDevice = {store: 1, deviceDetailsList: [{ deviceName: "", vendor: 1, modelNumber: 1, firmwareVersion: "", hardwareVersion: "", serialNumber: 1, warranty: "", installDate: mockDate}]};
        const mockFormattedRequestBody = {
            'restaurantId': 1,
            'workflow': 'iot',
            'deviceDetailsList': [{
                'deviceName': '',
                'vendorId': 1,
                'modelNumber': 1,
                'serialNumber': 1,
                'reportedVersion': '',
                'hardwareVersion': '',
                'warranty': '',
                'installDate': mockDate.toISOString()
            }]
        }
        const deviceResponse = await service.addNewDevice(mockDevice);
        expect(post).toHaveBeenCalledWith('https://device.ui-api.dev.bre.mcd.com/dev/on-boarding/devices', mockFormattedRequestBody);
        expect(deviceResponse).toBe(1);
    });

    it('should properly send device info to the Onboarding API on addNewNonIoTDevice', async () => {
        const mockDate = new Date();
        const mockDevice = {store: 1, deviceDetailsList: [{ deviceName: "", vendor: 1, modelNumber: 1, firmwareVersion: "", hardwareVersion: "", serialNumber: 1, warranty: "", installDate: mockDate, devicePropItems:{ macAddress: "", IPAddress: "",laneNumber: 2}}]};
        const mockFormattedRequestBody = {
            'restaurantId': 1,
            'workflow': 'iot',
            'deviceDetailsList': [{
                'deviceName': '',
                'vendorId': 1,
                'modelNumber': 1,
                'serialNumber': 1,
                'warranty': '',
                'installDate': mockDate.toISOString(),
                'action': 'mock-action',
                'devicePropItems': '{"macAddress": "AB:CC:5E:F7:8B:FD", "IPAddress": "11.22.33.44","laneNumber": 2}'
            }]
        }
        const deviceResponse = await service.addNewNonIoTDevice(mockDevice);
        expect(post).toHaveBeenCalledWith('https://device.ui-api.dev.bre.mcd.com/dev/on-boarding/onboardDevice', mockFormattedRequestBody);
        expect(deviceResponse).toBe(1);
    });
});