import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { CoreModule } from "@bref/core";

@Injectable({
    providedIn: CoreModule
})
export class FullscreenDialogService {

  private changePageNumSource = new BehaviorSubject(1);
  currentPageNum = this.changePageNumSource.asObservable();

  constructor() { }

  changePage(number: number) {
    this.changePageNumSource.next(number);
  }
}