import { Injectable, TemplateRef } from '@angular/core';
import { ComponentType } from '@angular/cdk/portal';
import { CoreModule } from '@bref/core';
import { MatDialog } from '@angular/material/dialog';

@Injectable({
  providedIn: CoreModule
})
export class DeviceDialogService {

  constructor(private dialog: MatDialog) { }

  open(content: ComponentType<any> | TemplateRef<any>, data?: object, afterClosed?: (result: object) => void, overlayClose?: boolean): void {
    const dialogRef = this.dialog
      .open(content, { data, disableClose: !overlayClose, maxWidth: '100vw !important', width: '100vw', height: '100vw' });
    if (!!afterClosed) {
      dialogRef.afterClosed().subscribe(afterClosed);
    }
  }
}