import {Injectable} from '@angular/core';
import {ApiService } from '@bref/core';
import { SolutionsEnvService } from '../solutions-env.service';
import { BehaviorSubject } from "rxjs";

@Injectable({
    providedIn: 'root'
})

export class BulkOnboardingDevicesService {
  
  private onDeviceOnboardSuccessSource = new BehaviorSubject(false);
  onboardSuccess = this.onDeviceOnboardSuccessSource.asObservable();
    constructor(private api:ApiService){ }

    /**
   * Get the auth token to send along with the header of post request.
   */
  private getBackendBaseHeaders() {
    return {
        Authorization: "Bearer " + SolutionsEnvService.get('msalIDToken')
    };
  }

    /**
   * Fetch installer details from token.
   */  
  private fetchInstallerDetails(){
    let token = SolutionsEnvService.get('msalIDToken');
    let base64Url = token.split('.')[1];
    let base64 = base64Url.replace(/-/g, '+').replace(/_/g, '/');
    let jsonPayload = decodeURIComponent(atob(base64).split('').map(function(c) {
        return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
    }).join(''));
    let parsedObj = JSON.parse(jsonPayload);
    let installerDetails = {
      installerName: parsedObj.firstname + " " + parsedObj.lastname ,
      installerEmail: parsedObj.email
    }
    return installerDetails;
  }

   /**
   * get method to return installer details.
   */
  public getInstallerDetails(){
    return this.fetchInstallerDetails();
  }


 
  /**
   * Bulk onboarding of devices
   * @param payload - payload of stores and devices to onboarded.
   */  
  public async onBoardDevices(payload) {
    const apiEndpoint = SolutionsEnvService.get('nonIotDeviceOnboardingBaseUrl');
    const response = await this.api.post<any>(`${apiEndpoint}`, payload,
    null,
    null, this.getBackendBaseHeaders());
    this.setDeviceOnboardSuccess(true);
    return response;
}

  /**
   *
   * @param popupStatus Boolean
   * This function sets the status of onboardSuccess when onboarding is successfully intiated
   */
   setDeviceOnboardSuccess(popupStatus: boolean) {
    this.onDeviceOnboardSuccessSource.next(popupStatus);
  }

}