import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from "rxjs";
import { vendorDetails, vendorTypeDetails } from '../interfaces/vendor.interface';
import { SolutionsEnvService } from '../solutions-env.service';
import { ApiService } from '@bref/core';
@Injectable({
    providedIn: 'root'
})

export class AddDeviceTypeVendorDetails {
    constructor(private api: ApiService) { }

    private vendorDetailsSource = new BehaviorSubject<vendorDetails[]>([]);
    addDevice = this.vendorDetailsSource.asObservable();

    /**
     * Function updated the service with data sent
     * @param data to be updated
     */
    setAddVendor(data: vendorDetails[]) {
        this.vendorDetailsSource.next(data);
    }

    /**
     * Returns the update servic object
     * @returns observable
     */
    getAddVendorObject(): Observable<any> {
        return this.vendorDetailsSource.asObservable();
    }

}