import { Component, OnInit, Input, ViewEncapsulation } from '@angular/core';
import {SelectedVendorDataService} from '../../services/selected-vendor-data.service';
import { DialogService } from '@bref/core';
import { ActivatedRoute, Router } from "@angular/router";
import { ConfirmVendorOnboardingPopupComponent } from '../../components/onboard-vendor/confirm-vendor-onboarding-popup/confirm-vendor-onboarding-popup.component';
import { ConfirmEditVendorPopupComponent } from '../../components/onboard-vendor/confirm-edit-vendor-popup/confirm-edit-vendor-popup.component';
@Component({
  selector: 'bre-vendor-onboarding',
  templateUrl: './vendor-onboarding.component.html',
  styleUrls: ['./vendor-onboarding.component.scss'],
  encapsulation: ViewEncapsulation.None
})
export class VendorOnboardingComponent implements OnInit {
  @Input() addedDevices: any = [];
  disableNext: boolean = true;
  disableAddvendorNext: boolean = true;
  disableAddVendorTypeNext:boolean = true;
  public totalPages: number = 3;
  totalPagesEdit: number = 0;
  currentPageNumber = 1;
  progressBarOptions = ['Add vendor details', 'Add device type', 'Confirmation summary'];
  progressBarOptionsEdit = [];
  context: { close: (dialogResult?: any) => void};
  changePage;
  currentUrl:any="";
  disableSave: boolean = true;
  vendorDetails;

  constructor(private selectedVendorDataService: SelectedVendorDataService, private dialog: DialogService,private router: Router,
    private route: ActivatedRoute) { 
    this.currentUrl = this.router.url.split('/')[this.router.url.split('/').length - 1]; 
  }

  ngOnInit(): void {
    this.selectedVendorDataService.addDevice.subscribe(() => {
      
      this.disableAddvendorNext = this.selectedVendorDataService.isAnyNullOnAddVendorObject();
      
    });
    this.selectedVendorDataService.addDeviceType.subscribe(() => {
        this.disableAddVendorTypeNext = this.selectedVendorDataService.isAnyNullOnAddVendorTyepObject();
    });

    this.selectedVendorDataService.getAddVendorObject().subscribe(res => {
      this.vendorDetails = res;
    });

  }

  /**
   * Function is triggered when ever user clicks on next/back button to handle a page change
   * @param pageNumber type number
   */
  handlePageChange(pageNumber: number) {
    this.currentPageNumber = pageNumber;
  }

  openConfirmation(){
    this.dialog.open(
      ConfirmVendorOnboardingPopupComponent, {
        panelClass: 'vendor-onboarding-dialog',
          width: '648px',
          type: 'Add Device Type',
          vendorName: this.vendorDetails[0].vendorName
      }); 
  }

  openEditConfirmation(){
    this.dialog.open(
      ConfirmEditVendorPopupComponent, {
        panelClass: 'edit-vendor-confirmation-dialog',
          width: '648px',
          vendorName: this.vendorDetails[0].vendorName
      }); 
  }
  setSaveButtonState($event){
    this.disableSave = $event;
  }

}