import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { CoreModule, DialogService } from '@bref/core';
import { RestaurantsApiService } from '../../services/restaurants-api.service';
import { SelectedDeviceDataService } from '../../services/selected-device-data.service';
import { FormBuilder, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { AccordionModule } from 'primeng/accordion';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import { FullscreenDialogComponent } from '../../components/fullscreen-dialog/fullscreen-dialog.component';
import { StoreDeviceComponent } from '../../components/store-device/store-device.component';
import { AddVendorComponent } from '../../components/onboard-vendor/add-vendor/add-vendor.component';
import { StoresDevicesComponent } from '../../components/stores-devices/stores-devices.component';
import { StoreSummaryComponent } from '../../components/store-summary/store-summary.component';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { VendorOnboardingComponent } from './vendor-onboarding.component';


xdescribe('VendorOnboardingComponent', () => {
  let component: VendorOnboardingComponent;
  let fixture: ComponentFixture<VendorOnboardingComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ VendorOnboardingComponent, FullscreenDialogComponent, AddVendorComponent ],
      imports: [CoreModule, AccordionModule, FormsModule, NoopAnimationsModule],
      providers: [ 
          RestaurantsApiService, 
          SelectedDeviceDataService, 
          DialogService,
          { provide: MAT_DIALOG_DATA, useValue: [] }
        ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(VendorOnboardingComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });
});
