import { Component, Input, OnInit, ViewEncapsulation } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { ComponentsApiService } from '../../services/components-api.service';
import { RestaurantsApiService } from '../../services/restaurants-api.service';
import { Breadcrumb } from '@bref/core/lib/components/breadcrumbs/breadcrumb.interface';
import {AddDeviceTypeComponent} from '../add-device-type/add-device-type.component';
import { DeviceDialogService } from '../../services/device-dialog.service';
import {AddDeviceTypeVendorDetails} from '../../services/add-data-type.service';
import {VendorOnboardingComponent} from '../vendor-onboarding/vendor-onboarding.component';
import { SelectedVendorDataService } from '../../services/selected-vendor-data.service';

@Component({
  selector: 'bre-vendor-details',
  templateUrl: './vendor-details.component.html',
  styleUrls: ['./vendor-details.component.scss'],
  encapsulation: ViewEncapsulation.None
})
export class VendorDetailsComponent implements OnInit {
  vendorId: any;
  vendorInfo: any;
  vendor: any;
  vendorConts: any;
  mcdconts: any;
  deviceType: any;
  isLoading:boolean = false;
  showLoader: boolean = false;

  breadcrumbs: Breadcrumb[] = [
   
    { label: 'Vendor Details', url: '../' },
    { label: '', url: '' }
  ];

  
  constructor(private route: ActivatedRoute,private api: ComponentsApiService,private restaurantsApiService: RestaurantsApiService, private dialog: DeviceDialogService, private vendorDetailsUpdate: AddDeviceTypeVendorDetails,private vendorData: SelectedVendorDataService) { }

  async ngOnInit(): Promise<void> {
    this.showLoader = true;
    this.route.params.subscribe((changes) => {
     this.vendorId = changes.vendorId;
     this.loadVendor(parseInt(changes.vendorId)).then(()=>{
       this.vendorConts = this.vendorInfo.contacts;
       this.vendor = this.vendorInfo.vendorData;
       this.deviceType = this.vendorInfo.devices;
       this.mcdconts = this.vendorInfo.mcdcontacts; 
       this.showLoader = false;      
     })     
    });

    this.vendorData.editSuccess.subscribe(status => {
      if(status) {
        this.loadVendor(parseInt(this.vendorId)).then(()=>{
          this.vendorConts = this.vendorInfo.contacts;
          this.vendor = this.vendorInfo.vendorData;
          this.deviceType = this.vendorInfo.devices;
          this.mcdconts = this.vendorInfo.mcdcontacts;
        })
      }
   });  
  }

  async loadVendor(vendorId: number) {
    await this.api.getVendorComponent(vendorId).then(res => {
      this.vendorInfo = res;
      this.vendorDetailsUpdate.setAddVendor(this.vendorInfo?.vendorData);
    });
  }

  showAddDeviceTypeDialog() {
    this.dialog.open(
      AddDeviceTypeComponent
    );
  }

  showAddVendorDialog(){
    this.dialog.open(VendorOnboardingComponent,this.vendorInfo);
  }

}
