import { Component, Input, OnInit } from "@angular/core";
import { DialogService } from '@bref/core';
import {ConfirmOnboardingPopupComponent} from "../../components/confirm-onboarding-popup/confirm-onboarding-popup.component";
import { distinct } from "rxjs/operators";
import { SelectItem } from 'primeng/api/selectitem';
import { OnboardingApiService } from '../../services/onboarding-api.service';
import { RestaurantsApiService } from '../../services/restaurants-api.service';
import { Vendor } from '../../interfaces/vendor.interface';
import { SelectedDeviceDataService } from "../../services/selected-device-data.service";


@Component({
    selector: 'bre-device-onboarding',
    templateUrl: './device-onboarding.component.html',
    styleUrls: ['./device-onboarding.component.scss']
})

export class DeviceOnboardingComponent implements OnInit {
    public vendors: Vendor[];
    public suppliers: SelectItem[];
    @Input() addedDevices: any = [];
    @Input() errorState: any;
    disableNext: boolean = true;
    disableStoreNext: boolean = true;
    public totalPages: number = 2;
    currentPageNumber = 1;
    progressBarOptions = ['Add device(s)', 'Confirmation Summary'];
    context: { close: (dialogResult?: any) => void };
    public devicesToStores: any = {};

    constructor(
        private dialog: DialogService,
        private restaurantsApi: RestaurantsApiService,
        private selectedDeviceService: SelectedDeviceDataService
    ) {
        
     }
    ngOnInit() {
      this.selectedDeviceService.addStore.subscribe(() => {
        this.disableStoreNext = this.selectedDeviceService.isAnyNullOnDeviceObject();
        
      })

      this.selectedDeviceService.getErrorState().subscribe((data) => {
        this.errorState = data;
      })
        
      this.getVendorSuppliers();
        this.selectedDeviceService.getAddStoreObject().subscribe(data => {
          let totalDevices: number = 0;
          data.map(store => totalDevices+=store.properties.length);
          this.addedDevices = totalDevices;         
      });  
       
     }
     async getVendorSuppliers() {
        this.vendors = await this.restaurantsApi.getVendors();
        this.suppliers = this.vendors.map(x => ({
          label: `${x.id} - ${x.name}`,
          value: x.id
        }));
        
      }
    
      getVendorName(vendorId) {
        return this.vendors.filter(vendor => {
          return vendor.id === vendorId
        })
      }

    handlePageChange(pageNumber: number) {
        
        this.currentPageNumber = pageNumber;
    }
    openConfirmation(){
      this.dialog.open(
        ConfirmOnboardingPopupComponent, {
          panelClass: 'vendor-details-dialog',
            width: '648px',
            data: {
              totaldevices: this.devicesToStores
            }}
      ); 
    }

    
}