import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { DeviceOnboardingComponent } from './device-onboarding.component';
import { CoreModule, DialogService } from '@bref/core';
import { RestaurantsApiService } from '../../services/restaurants-api.service';
import { SelectedDeviceDataService } from '../../services/selected-device-data.service';
import { FormBuilder, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { AccordionModule } from 'primeng/accordion';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import { FullscreenDialogComponent } from '../../components/fullscreen-dialog/fullscreen-dialog.component';
import { StoreDeviceComponent } from '../../components/store-device/store-device.component';
import { AddDeviceComponent } from '../../components/add-device/add-device.component';
import { StoresDevicesComponent } from '../../components/stores-devices/stores-devices.component';
import { StoreSummaryComponent } from '../../components/store-summary/store-summary.component';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
jest.useFakeTimers();
const mockMatDialogRef = { close: jest.fn() };
xdescribe('DeviceOnboardingComponent', () => {
  let component: DeviceOnboardingComponent;
  let fixture: ComponentFixture<DeviceOnboardingComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ 
          DeviceOnboardingComponent, 
          FullscreenDialogComponent, 
          StoresDevicesComponent, 
          AddDeviceComponent,
          StoreDeviceComponent,
          StoreSummaryComponent 
        ],
      imports: [CoreModule, AccordionModule, FormsModule, NoopAnimationsModule],
      providers: [ 
          RestaurantsApiService, 
          SelectedDeviceDataService, 
          DialogService,
          { provide: MAT_DIALOG_DATA, useValue: [] },
          { provide: MatDialogRef, useValue: mockMatDialogRef },
        ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(DeviceOnboardingComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });
});
