import { Component, OnInit, Inject, ViewEncapsulation } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { Component as Device } from '../../interfaces/component.interface';
import { ComponentsApiService } from '../../services/components-api.service';
import { Breadcrumb } from '@bref/core/lib/components/breadcrumbs/breadcrumb.interface';
import { AssetType } from '../../interfaces/component-filters.interface';
import { RestaurantsApiService } from '../../services/restaurants-api.service';

@Component({
  selector: 'bre-device-details',
  templateUrl: './device-details.component.html',
  styleUrls: ['./device-details.component.scss'],
  encapsulation: ViewEncapsulation.None
})
export class DeviceDetailsComponent implements OnInit {

  device: Device;
  types: AssetType[];
  isLoading:boolean = false;

  breadcrumbs: Breadcrumb[] = [
    { label: 'Device Details', url: '../' },
    { label: '', url: '' }
  ];
  hierarchyCoop: any;
  hierarchyRegion: any;
  activityLogDetails;
  hierarchyMarket;

  constructor(@Inject(DOCUMENT) private document: any,private route: ActivatedRoute, private router: Router, private api: ComponentsApiService,private restaurantsApiService: RestaurantsApiService) { }

  async ngOnInit(): Promise<void> {
    this.getTypes();
    this.isLoading = true;
    this.route.params.subscribe((changes) => {
      this.loadDevice(parseInt(changes.deviceId, 10));
    });
  }

  async getTypes() {
    this.types = await this.api.getAssetTypes();
  }

  getComponentTypeName(typeId) {
    if (this.types !== undefined) {
      return ((this.types.find(x => x.id == typeId) ? this.types.find(x => x.id == typeId).name : ''));
    }
  }

  navigateToEditDetails() {
    this.router.navigate(['edit'], { relativeTo: this.route });
  }

  async loadDevice(deviceId: number) {
    this.device = await this.api.getComponent(deviceId);
    if(this.device.hierarchyNode) {
      this.hierarchyCoop = await this.api.getRestauratDetails(this.device.hierarchyNode);
      this.hierarchyRegion = await this.api.getRestauratDetails(this.hierarchyCoop.parentNodeId);
      this.hierarchyMarket = await this.api.getRestauratDetails(this.hierarchyRegion.parentNodeId);
    }
    this.isLoading = false;
  }
  /**
   * 
   * @param device Device details
   * This functions navigates user to certifcates page, to show respective certificate
   * details
   */
  navigateToCertificates(device: Device) {
    this.router.navigate(['solutions/certificates', {statusActive: 'active', statusAttention: 'attention', deviceId: device.id}]);
  }
}