import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { DeviceDetailsComponent } from './device-details.component';
import { RouterTestingModule } from '@angular/router/testing';
import { CoreModule } from '@bref/core';
import { SolutionsNavigationBarComponent } from '../../components/solutions-navigation-bar/solutions-navigation-bar.component';
import { ComponentStatusPillComponent } from '../../components/component-status-pill/component-status-pill.component';

xdescribe('DeviceDetailsComponent', () => {
  let component: DeviceDetailsComponent;
  let fixture: ComponentFixture<DeviceDetailsComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [DeviceDetailsComponent, SolutionsNavigationBarComponent, ComponentStatusPillComponent],
      imports: [RouterTestingModule, CoreModule],
      providers: []
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(DeviceDetailsComponent);
    component = fixture.componentInstance;
    component.types = [
      {id: '1', name: '1'}
    ];
    component.device = {
      name: 'd',
      serialNumber: '123',
      warranty: 'May 5, 2020',
      // technicalName: 'p',
      market: 'k',
      store: 'n',
      type: '1',
      // lineOfBusiness: 'h',
      // cellLocation: 'a',
      // manufacturer: 'j',
      model: 'l',
      // description: 'c',
      supplier: 'o',
      // mainUsage: 'i',
      certificate: 'b',
      function: 'e',
      id: 'f',
      ipAddress: 'g',
      status: 'm',
      storeId: '0',
      version: '1.3',
      laneNumber: '1',
      macAddress: 'DC:AC:7E:G3:AB:D9',
      onboardingStatus: 'Onboarding message sent',
      installDate: '',
      hardwareVersion: '0',
      hierarchyNode: 500080,
      isIOTDevice: true
    };
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display device properties correctly', () => {
    const propertiesEl = fixture.nativeElement.querySelectorAll('[breGridColumn]');

    // return to 15 after all properties are available from API
    expect(propertiesEl.length).toBe(9);
    for (let i = 0; i < propertiesEl.length; i++) {
      expect(propertiesEl[i].innerHTML).toContain(Object.values(component.device)[i]);
    }
  });

  /* uncomment these tests when the gutter is uncommented
  it('should display the device logs button', () => {
    const actionButtonsEl = fixture.nativeElement.querySelectorAll('.device-details-gutter .device-details-gutter-item .device-details-gutter-item-action button');

    expect(actionButtonsEl[0].innerHTML).toContain('View Device Logs');
  });

  it('should display the open ticket button', () => {
    const actionButtonsEl = fixture.nativeElement.querySelectorAll('.device-details-gutter .device-details-gutter-item .device-details-gutter-item-action button');

    expect(actionButtonsEl[1].innerHTML).toContain('Open a Ticket');
  });

  it('should display the edit device button', () => {
    const edit = jest.fn();
    component.navigateToEditDetails = edit;

    const editButtonEl = fixture.nativeElement.querySelector('.device-details-gutter .device-details-gutter-edit button');

    expect(editButtonEl.innerHTML).toContain('Edit Device');

    editButtonEl.click();

    expect(edit).toHaveBeenCalledTimes(1);
  });
  */
});