import { Component, OnInit } from '@angular/core';
import { Component as Device } from '../../interfaces/component.interface';
import { ComponentsApiService } from '../../services/components-api.service';
import { ActivatedRoute } from '@angular/router';
import { Breadcrumb } from '@bref/core/lib/components/breadcrumbs/breadcrumb.interface';

@Component({
  selector: 'bre-device-details-edit',
  templateUrl: './device-details-edit.component.html',
  styleUrls: ['./device-details-edit.component.scss']
})
export class DeviceDetailsEditComponent implements OnInit {

  device: Device;

  breadcrumbs: Breadcrumb[] = [
    { label: 'Devices', url: '../../' },
    { label: 'Device Details', url: '../' },
    { label: '', url: '' }
  ];

  constructor(private route: ActivatedRoute, private api: ComponentsApiService) { }

  ngOnInit(): void {
    this.route.params.subscribe((changes) => {
      this.loadDevice(parseInt(changes.deviceId, 10));
    });
  }

  private async loadDevice(deviceId: number) {
    this.device = await this.api.getComponent(deviceId);
  }
}
