import { Component, OnInit } from '@angular/core';
import {SelectedVendorDataService} from '../../services/selected-vendor-data.service';
import { DialogService } from '@bref/core';
import { ConfirmVendorOnboardingPopupComponent } from '../../components/onboard-vendor/confirm-vendor-onboarding-popup/confirm-vendor-onboarding-popup.component';
import {AddDeviceTypeVendorDetails} from '../../services/add-data-type.service';
@Component({
  selector: 'bre-add-device-type',
  templateUrl: './add-device-type.component.html',
  styleUrls: ['./add-device-type.component.scss']
})
export class AddDeviceTypeComponent implements OnInit {
  disableNext: boolean = true;
  disableAddDetails: boolean = true;
  public totalPages: number = 2;
  currentPageNumber = 1;
  progressBarOptions = ['Add device details', 'Confirmation Summary'];
  context: { close: (dialogResult?: any) => void };
  vendorDetails;
  public devicesToStores: any = {};
  constructor(private selectedVendorDataService: SelectedVendorDataService, private dialog: DialogService, private addDeviceTypeVendorDetails: AddDeviceTypeVendorDetails) { }

  ngOnInit(): void {
    this.selectedVendorDataService.addDeviceType.subscribe(() => {
      this.disableAddDetails = this.selectedVendorDataService.isAnyNullOnAddVendorTyepObject();
    });
  }

    /**
   * Function is triggered when ever user clicks on next/back button to handle a page change
   * @param pageNumber type number
   */
     handlePageChange(pageNumber: number) {
      this.currentPageNumber = pageNumber;
    }

    saveDeviceType() {
      this.addDeviceTypeVendorDetails.getAddVendorObject().subscribe(data => {
        this.vendorDetails = data;
      });
      this.dialog.open(
        ConfirmVendorOnboardingPopupComponent, {
          panelClass: 'vendor-onboarding-dialog',
          width: '648px',
          vendorName: this.vendorDetails?.data?.attributes?.name
        }
        ); 
    }

}
