export interface RestaurantsApiResponse {
  data: RestaurantData[],
  links: {
    first: string,
    last: string
  },
  included: RestaurantIncludedData[],
  meta: {
    totalResourceCount: number
  }
}

export interface HierarchyApiDatatList {
  data: HierarchyApiData[];
  included: HierarchyApiData[];
  totalItemCount: number;
}

export interface HierarchyApiResponse {
  data: HierarchyApiData[];
  included: HierarchyApiData[];
  meta: {
    totalResourceCount: number;
  };
}

export interface HierarchyApiData {
  relationships: any;
  id: number;
  type: string;
  attributes: {
    mcdInternalNodeId: number;
    mcdInternalNodeName: string;
    parentHierarchyLevelId: number;
    created?: string;
    mcdRestaurantId: number;
    parentNodeId: number;
    isActive: number;
    updated?: string;
  };
}

export interface Device {
  id: string,
  name: string,
  deviceFlag: boolean,
  abbreviation: string
}

export interface RestarantHeirarchyResponse {
  data: HierarchyApiData,
  links: {
    first: string,
    last: string,
  }
}

export interface RestaurantVendorsApiResponse {
  data: VendorData[],
  links: {
    first: string,
    last: string
  },
  meta: {
    totalResourceCount: number
  }
}
export interface RestaurantDeviceApiResponse {
  data: DeviceData[],
  links: {
    first: string,
    last: string
  },
  meta: {
    totalResourceCount: number
  }
}

export interface ArtifactoryStorage {
  repo: string,
  path: string,
  created: string,
  lastModified: string,
  lastUpdated: string,
  children: ArtifactoryFolder[],
  uri: string
}

export interface ArtifactoryFolder {
  uri: string;
  folder: boolean
}

export interface RestaurantData {
  id: string,
  type: string,
  attributes: {
    created: string,
    name: string,
    updated: string
  },
  relationships: {
    market: {
      data: {
        id: string
      },
      links: {
        self: string,
        related: string
      }
    },
    components: {
      links: {
        self: string,
        related: string
      }
    },
    ownerOperator: {
      links: {
        self: string,
        related: string
      }
    }
  },
  links: {
    self: string
  }
}

export interface VendorData {
  id: string,
  type: string,
  attributes: {
    created: string,
    name: string,
    updated: string,
    contactInfo: string,
    contactInfoType: string
    deviceFlag: boolean,
    notes: string
  },
  relationships: {
    components: {
      links: {
        self: string,
        related: string
      }
    },
    type: {
      links: {
        self: string,
        related: string
      }
    }
  },
  links: {
    self: string
  }
}

export interface DeviceData {
  id: string,
  type: string,
  attributes: {
    created: string,
    name: string,
    deviceFlag: boolean,
    abbreviation: string
  },
  relationships: {
    deviceProp: {
      links: {
        self: string,
        related: string
      }
    },
    vendor: {
      links: {
        self: string,
        related: string
      }
    }
  },
  links: {
    self: string
  }
}

export interface RestaurantIncludedData {
  id: string,
  type: string,
  attributes: any
}