export interface AddStoreSource {
    store?: string,
    properties?: {
        vendor?: string,
        dName: string,
        dLane: string,
        dAngle: string,
        modelNo: string,
        sNo: string,
        warranty: string,
        install: string,
        hardwareOptions: string,
        firmware: string,
        ip: string,
        mac: string,
        lane: string,
        deviceFlag?: string
    }[]
}

export interface DeviceFlag {
    value: string,
    deviceFlag: boolean,
    id: string,
    abbreviation: string
}

export interface DevicePropResponse {
        data: DevicePropList[],
        links: {
            first: string,
            last: string,
            self: string,
        },
        meta: {
            totalResourceCount: number
        },
}

export interface DevicePropList {
        attributes: {
            created: string,
            dataType: string,
            propertyName: string,
        },
        id: string,
        links: {
            self: String
        },
        relationships: {
            device: {
                links: {
                    self: {}
                }
            }
        },
        type: string
}