export interface ComponentsApiResponse {
    data: ComponentData[],
    included?: IncludedData[],
    links: {
        first: string,
        last: string,
        next: string
    },
    meta: {
        totalResourceCount: number
    }
}

export interface ComponentApiResponse {
    data: ComponentData,
    included?: IncludedData[]
}

export interface AssetTypeApiResponse {
    data: [{
        id: string,
        type: string,
        links: {
            self: string
        },
        attributes: {
            created?: string,
            name: string,
            description?: string,
            updated?: string
        },
        relationships: {
            components: {
                links: {
                    self: string,
                    related: string
                }
            }
        }
    }]
}

export interface ComponentData {
    id: string,
    type: string,
    attributes: {
        serialNumber: string,
        reportedVersion: string,
        hardwareVersion?: string,
        installDate: string,
        created: string,
        parentComponent: number,
        name: string,
        warranty: string,
        modelNumber: number,
        type: string,
        updated: string,
        vendorName: string,
        firmwareVersion: string,
        storeName: string,
        onboardingStatus: string,
        deviceName: string,
        displayName: string,
        identificationName: string
    }
    relationships: {
        componentAuditHistory: {
            links: Links
        },
        vendor: {
            data,
            links: Links
        },
        restaurant: {
            data: {
                id: string,
                type: string
            },
            links: Links
        },
        componentGroup: {
            links: Links
        },
        componentProps: {
            data: any[],
            links: Links
        },
        type: {
            data: {
                id: string,
                type: string
            },
            links: Links
        }
    },
    links: {
        self: string
    }
}

export interface VendorApiData {
    id: string,
    type: string,
    attributes: {
        created: string,
        name: string,
        notes: string,
        updated: string
    }
    relationships: {
        components: {
            links: Links
        },
        
        device: {
            links: Links
        },
        vendor_contacts: {
            data: {
                id: string,
                type: string
            },
            links: Links
        }
    },
    links: {
        self: string
    }
}

export interface IncludedData {
    id: string,
    type: string,
    attributes: any,
    relationships: any,
    links: {
        self: string
    }
}

interface Links {
    self: string,
    related: string
}
