export interface Component {
    id: string,
    status: string,
    name: string,
    model: string,
    type: string,
    store: string,
    storeId: string,
    function: string,
    ipAddress: string,
    serialNumber: string,
    warranty: string,
    technicalName?: string,
    market: string,
    lineOfBusiness?: string,
    cellLocation?: string,
    manufacturer?: string,
    supplier: string,
    description?: string,
    mainUsage?: string,
    certificate: string,
    version: string,
    laneNumber: string,
    macAddress: string,
    onboardingStatus: string
    installDate: string,
    hierarchyNode: number,
    isIOTDevice: boolean,
    hardwareVersion?: string,
    activityLog?: any,
    dynamicFields?: dynamicField[],
    vendorName?: string,
    storeName?: string,
    firmwareVersion? : string,
    displayName?: string,
    installerName?:string,
    installerEmail?: string
}

export interface dynamicField {
    value: string,
    label: string
}

export interface activityLogDetails {
    'heading': string,
    'sourceType': string,
    'description': string,
    'createdDate': string
}

export interface ComponentList {
    totalComponentCount: number,
    data: Component[]
}

export interface ComponentDetails {
    deviceName: string,
    vendorId: number,
    modelNumber: number,
    serialNumber: number,
    warranty: string,
    installDate: string,
    reportedVersion: string,
    hardwareVersion: string
}

export interface DeviceProperty {
    propName: string,
    propValue: string
}
export interface OnboardingInfo {
    restaurantId: number,
    deviceDetailsList: ComponentDetails[]
}