export interface CertificateApiResponse {
  data: CertificateApiData[];
  included: IncludedApiData[];
  meta: {
    totalResourceCount: number;
  };
}

export interface CertificateApiData {
  id?: string;
  type: string;
  attributes: {
      propertyName?: string;
      propertyValue?: string;
      created?: string;
      expiry: string;
      updated?: string;
  };
  relationships: {
    component: {
        data: RelatedComponentData
    },
    restaurant: {
        data: RelatedRestaurantData
    }
    };
}

export interface IncludedApiData {
  id: string;
  type: string;
  attributes: any;
  relationships?: any;
}

export interface RelatedComponentData {
  id: string;
  type: string;
}

export interface RelatedRestaurantData {
  id: string;
  type: string;
}

interface Links {
  self: string,
  related: string
}