import { Component, OnChanges, OnInit  } from '@angular/core';
import { SelectedDeviceDataService } from "../../services/selected-device-data.service";
import { Input } from "@angular/core";
import { RestaurantsApiService } from '../../services/restaurants-api.service';
import { Vendor } from '../../interfaces/vendor.interface';
import { SelectItem } from 'primeng/api/selectitem';



@Component({
  selector: 'bre-stores-devices',
  templateUrl: './stores-devices.component.html',
  styleUrls: ['./stores-devices.component.scss']
})
export class StoresDevicesComponent implements OnInit{
  @Input() stores: any = [];
  public vendors: Vendor[];
  public suppliers: SelectItem[];
  public allStores = [];
  public storeLabel:"";

  constructor(private selectedDeviceService: SelectedDeviceDataService,private restaurantsApi: RestaurantsApiService) { 
    
  }

  ngOnInit() {    
     this.selectedDeviceService.getAddStoreObject().subscribe(data => {
      this.stores = data;
  });  
  }
}
