import { Component, OnInit , Input } from '@angular/core';
import { RestaurantsApiService } from '../../services/restaurants-api.service';
import { Vendor } from '../../interfaces/vendor.interface';
import { SelectItem } from 'primeng/api/selectitem';


@Component({
  selector: 'bre-store-summary',
  templateUrl: './store-summary.component.html',
  styleUrls: ['./store-summary.component.scss']
})
export class StoreSummaryComponent implements OnInit {
  @Input() store: any = [];  
  public vendors: Vendor[];
  public suppliers: SelectItem[];
  public allStores = [];
  public storeLabel:"";
  @Input() storeName:any = "";
  @Input() devicesLength:any = 0;
  constructor(private restaurantsApi: RestaurantsApiService) { }

  ngOnInit() {
    this.getStoreOptions();    
    this.devicesLength = this.store.properties ? this.store.properties.length:0;
  }

  /**
   * Get all stores
   * Get selected storename from getStoreName
   */
  async getStoreOptions() {
    this.allStores = await this.restaurantsApi.getAllStores();   
    await  this.getStoreName();
  }

   /**
   * Filter Selected store name from all stores.
   */
  getStoreName(){  
    let filteredStore : any = this.allStores.filter(store =>  store.id === this.store.store); 

    this.storeLabel = filteredStore.map(x => ({
      label: `${x.marketName} - ${x.id} - ${x.name}`,
      value: x.id
    }));
    this.storeName = [...this.storeLabel];
    this.storeName =this.storeName[0]?.label;    
  }
}
