import { Component, Input, OnChanges } from '@angular/core';
import { NavigationBarItem } from '@bref/core';
import { Router, ActivatedRoute } from '@angular/router';

@Component({
  selector: 'bre-solutions-navigation-bar',
  templateUrl: './solutions-navigation-bar.component.html',
  styleUrls: ['./solutions-navigation-bar.component.scss']
})
export class SolutionsNavigationBarComponent implements OnChanges {
  @Input() activeUrl: string;

  items: NavigationBarItem[];

  private _items = [
    /* uncomment when Dashboard route is ready
    {
      label: 'Solutions Dashboard',
      url: 'dashboard',
      isActive: false
    },
    */
    /* uncomment when Bundles route is ready
    {
      label: 'Bundles',
      url: 'bundles',
      isActive: false
    },
    */
    {
      label: 'Devices',
      url: 'devices',
      isActive: false
    },
    {
      label: 'Vendors',
      url: 'vendors',
      isActive: false
    },
    //commented for future use {
    //   label: 'Software & Assets',
    //   url: 'assets',
    //   isActive: false
    // },
    {
      label: 'Certificates',
      url: 'certificates',
      isActive: false
    }

  ];

  constructor(private route: ActivatedRoute) {}

  ngOnChanges(changes) {
    if (changes.activeUrl) {
      const prefix = this.route.snapshot?.parent?.routeConfig?.path;
      this.items = this._items.map(x => ({
        label: x.label,
        url: `/${prefix}/${x.url}`,
        isActive: this.activeUrl.includes(x.url)
      }));
    }
  }
}
