import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { NavigationBarComponent } from '@bref/core';
import { SolutionsNavigationBarComponent } from './solutions-navigation-bar.component';
import { RouterTestingModule } from '@angular/router/testing';

describe('SolutionsNavigationBarComponent', () => {
  let component: SolutionsNavigationBarComponent;
  let fixture: ComponentFixture<SolutionsNavigationBarComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [RouterTestingModule],
      declarations: [SolutionsNavigationBarComponent, NavigationBarComponent]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SolutionsNavigationBarComponent);
    component = fixture.componentInstance;
    component.activeUrl = 'devices';
    component.ngOnChanges({ activeUrl: true });
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display links to every solutions page', () => {
    const links = fixture.nativeElement.querySelectorAll('a');

    expect(links.length).toBe(3); // return to 3 once Solutions Dashboard and Bundles are valid routes
    /*expect(links[0].innerHTML).toContain('Solutions Dashboard');
    expect(links[0].href).toBe('https://github.com/undefined/dashboard');
    expect(links[1].innerHTML).toContain('Bundles');
    expect(links[1].href).toBe('https://github.com/undefined/bundles');*/
    expect(links[0].innerHTML).toContain('Devices');
    expect(links[0].href).toBe('https://github.com/undefined/devices');
    expect(links[1].innerHTML).toContain('Vendors');
    expect(links[1].href).toBe('https://github.com/undefined/vendors');
    // expect(links[2].innerHTML).toContain('Software &amp; Assets');
    // expect(links[2].href).toBe('https://github.com/undefined/assets');
    expect(links[2].innerHTML).toContain('Certificates');
    expect(links[2].href).toBe('https://github.com/undefined/certificates');
  });
});
