import { Component, Input, OnChanges } from '@angular/core';
import { NavSubMenu } from '@bref/core';

@Component({
  selector: 'bre-solutions-nav-button',
  templateUrl: './solutions-nav-button.component.html',
  styleUrls: ['./solutions-nav-button.component.scss']
})
export class SolutionsNavButtonComponent implements OnChanges {

  @Input() isDisabled: boolean;
  @Input() solutionsUrlPrefix: string;
  defaultIcon: string = 'assets/images/Solutions_Default.svg';
  selectedIcon: string = 'assets/images/Solutions_Selected.svg';

  subMenus: NavSubMenu[];

  ngOnChanges(changes) {
    if(changes.solutionsUrlPrefix) {
      this.subMenus = [
        /* uncomment when Dashboard route is ready
        {
          label: 'Solutions Dashboard',
          url: `${this.solutionsUrlPrefix}/dashboard`
        },   
        */
        /* uncomment when Bundles route is ready     
        {
          label: 'Bundles',
          url: `${this.solutionsUrlPrefix}/bundles`
        },
        */        
        {
          label: 'Devices',
          url: `${this.solutionsUrlPrefix}/devices`
        },
        {
          label: 'Vendors',
          url: `${this.solutionsUrlPrefix}/vendors`
        },
        //Commented for future use {
        //   label: 'Software & Assets',
        //   url: `${this.solutionsUrlPrefix}/assets`
        // },
        {
          label: 'Certificates',
          url: `${this.solutionsUrlPrefix}/certificates`
        }      
      ];
    }
  }
}
