import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { RouterTestingModule } from '@angular/router/testing';
import { NavButtonComponent } from '@bref/core';
import { SolutionsNavButtonComponent } from './solutions-nav-button.component';

describe('SolutionsNavButtonComponent', () => {
  let component: SolutionsNavButtonComponent;
  let fixture: ComponentFixture<SolutionsNavButtonComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ RouterTestingModule ],
      declarations: [ NavButtonComponent, SolutionsNavButtonComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SolutionsNavButtonComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should have a label of "Solutions"', () => {
    expect(fixture.nativeElement.querySelector('.nav-button-text').textContent).toBe('Solutions');
  });

  it('should have a icon source that matches the property declared in menu-nav-button', () => {
    const computedSrc = 'https://github.com/' + component.defaultIcon;
    expect(fixture.nativeElement.querySelector('.nav-button-icon img').src).toBe(computedSrc);
  });
});
