import { Component, OnInit , Inject, Input} from '@angular/core';
import {MAT_DIALOG_DATA} from '@angular/material/dialog';
import {Vendor} from '../../interfaces/vendor.interface';
import { ComponentsApiService } from '../../services/components-api.service';


@Component({
  selector: 'bre-onboarding-vendor-details',
  templateUrl: './onboarding-vendor-details.component.html',
  styleUrls: ['./onboarding-vendor-details.component.scss']
})
export class OnboardingVendorDetailsComponent implements OnInit {
  @Input() vendor: any = {}
  vendorInfo: any;
  @Input() vendorContacts: any;
  constructor(@Inject(MAT_DIALOG_DATA) public data:any , private api: ComponentsApiService) { }
  ngOnInit(): void {
    this.vendor = this.data.vendor;
    this.vendorContacts = this.data?.contacts?.length > 0 ? this.data.contacts[0]: "";    
  }

}
