import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { DropdownComponent, CoreModule } from '@bref/core';
import { ReactiveFormsModule, FormsModule, FormBuilder } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { OnboardingDialogComponent } from './onboarding-dialog.component';
import { OnboardingApiService } from '../../services/onboarding-api.service';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { Component } from '@angular/core';
import { RestaurantsApiService } from '../../services/restaurants-api.service';
import { RouterTestingModule } from '@angular/router/testing';

@Component({
  selector: 'bre-dropdown',
  template: `
    <button class="mock-dropdown-item" *ngFor="let item of items" (click)="selectItem(item)">{{item.label}}</button>
  `
})
class DropdownMock extends DropdownComponent {
  selectItem(item) {
    this.parentForm.get(this.controlName).setValue(item.value);
  }
}

const mockMatDialogRef = { close: jest.fn() };

xdescribe('OnboardingDialogComponent', () => {
  let component: OnboardingDialogComponent;
  let fixture: ComponentFixture<OnboardingDialogComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [RouterTestingModule, FormsModule, ReactiveFormsModule, BrowserAnimationsModule, CoreModule],
      declarations: [OnboardingDialogComponent, DropdownMock],
      providers: [
        { provide: MAT_DIALOG_DATA, useValue: {} },
        { provide: MatDialogRef, useValue: mockMatDialogRef },
        OnboardingApiService,
        RestaurantsApiService
      ]
    })
    TestBed.overrideModule(CoreModule, {
      remove: {
        declarations: [DropdownComponent],
        exports: [DropdownComponent]
      }
    });
    TestBed.compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(OnboardingDialogComponent);
    component = fixture.componentInstance;
    component.stores = [
      { label: "Foo", value: 1},
      { label: "Bar", value: 2},
    ]
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should allow user to select type of component to onboard', () => {
    const typesEl = fixture.nativeElement.querySelectorAll('.onboarding-component-types-container > div');

    // change expect statement to '2' once IOT Solution onboarding is allowed
    expect(typesEl.length).toBe(1);
    expect(fixture.nativeElement.querySelector('.onboarding-button-container button').disabled).toBe(true);

    /* this test will be re-enabled once IOT Solution onboarding is avaiable
    typesEl[1].click();

    expect(component.selectedType).toBe(component.componentTypes.solution);
    */

    typesEl[0].click();

    expect(component.selectedType).toBe(component.componentTypes.iotDevice);

    fixture.detectChanges();
    expect(fixture.nativeElement.querySelector('.onboarding-button-container button').disabled).toBe(false);
  });

  /* re-enable this test when the Select Device screen is un-commented
  it('should allow user to select component to onboard', async(() => {
    //select device type
    const typesEl = fixture.nativeElement.querySelectorAll('.onboarding-component-types-container > div');
    typesEl[0].click();
    fixture.detectChanges();

    //go to next page
    const continueButton = fixture.nativeElement.querySelector('.onboarding-button-container button');
    continueButton.click();
    fixture.detectChanges();

    expect(component.selectedDevice).toBeUndefined();
    fixture.whenStable().then(() => {
      fixture.detectChanges();
      
      const firstOption = fixture.nativeElement.querySelector('.mock-dropdown-item');
      firstOption.click();

      expect(component.selectedDevice).toStrictEqual({
        id: null,
        status: null,
        manufacturer: 'Hella Aglaia',
        model: 'APS-90E',
        name: null,
        type: null,
        store: null,
        storeId: null,
        function: null,
        ipAddress: null,
        serialNumber: undefined,
        warranty: null,
        version: null,
        technicalName: null,
        market: null,
        lineOfBusiness: null,
        cellLocation: null,
        supplier: null,
        description: null,
        mainUsage: null,
        certificate: null
      });
    });
  }));
  */

  it('should onboard a device when the user completes the form', async(() => {
    //select device type
    const typesEl = fixture.nativeElement.querySelectorAll('.onboarding-component-types-container > div');
    typesEl[0].click();
    fixture.detectChanges();

    //go to next page
    const goToPage2Button = fixture.nativeElement.querySelector('.onboarding-button-container button');
    goToPage2Button.click();
    fixture.detectChanges();

    fixture.whenStable().then(() => {
      /* re-enable this section when the Select Device screen is un-commented 
      fixture.detectChanges();
      
      //select solution
      const firstOption = fixture.nativeElement.querySelector('.mock-dropdown-item');
      firstOption.click();
      fixture.detectChanges();

      //go to next page
      const goToPage3Button = fixture.nativeElement.querySelector('.onboarding-button-container button');
      goToPage3Button.click();
      */

      fixture.detectChanges();
      spyOn(component, 'onboardDevice');
      const compiled = fixture.nativeElement;

      const button = compiled.querySelector('.onboarding-button-container button');
      button.click();

      expect(component.onboardDevice).toHaveBeenCalled();
    });
  }));
});
