import { Component, OnInit, Inject, Input } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ToastService } from '@bref/core';
import { SelectedVendorDataService } from '../../../services/selected-vendor-data.service';

@Component({
  selector: 'bre-confirm-vendor-onboarding-popup',
  templateUrl: './confirm-vendor-onboarding-popup.component.html',
  styleUrls: ['./confirm-vendor-onboarding-popup.component.scss']
})
export class ConfirmVendorOnboardingPopupComponent implements OnInit {
  public stores: any = [];
  public payloadData: any = [];
  showLoader: boolean;
  deviceDetails;
  deviceDetailsType;
  isDeviceType:boolean = false;
  constructor(public dialogRef: MatDialogRef<ConfirmVendorOnboardingPopupComponent>, private matDialog: MatDialog, private toast: ToastService, private vendorData: SelectedVendorDataService,@Inject(MAT_DIALOG_DATA) public data: any) { }

  ngOnInit() {
    this.vendorData.addDevice.subscribe(data => {
      this.deviceDetails = data[0];
    });
    this.vendorData.addDeviceType.subscribe(data => {
      this.deviceDetailsType = data;
    });
    this.isDeviceType = (this.data.type === 'Add Device Type');
  }


  /**
   * Send the selected devices and stores to BE on user confirmation.
   */
  onBoardVendor() {
    this.showLoader = true;
    this.vendorData.onBoardVendor().then(response => {
      this.showLoader=false;
      if(response[0].status?.toLowerCase() === 'success') {
        this.toast.success('Onboarding successfully initiated');
        this.matDialog.closeAll();
      } else {
        this.toast.error('Onboarding initiation failed');
        this.dialogRef.close();
      }
    }).catch(error => {
      this.showLoader = false;
      this.dialogRef.close();
    });
  }

  /**
   * Cancel button click.
   */
  cancelBoarding() {
    this.dialogRef.close()
  }

  saveDeviceType() {
    this.showLoader = true;
    this.vendorData.addVendorDeviceType().then(response => {
      this.showLoader=false;
      if(response[0].status?.toLowerCase() === 'success') {
        this.toast.success('Device type(s) successfully saved to vendor.');
        this.matDialog.closeAll();
      } else {
        this.toast.error('Device type(s) could not be saved to vendor.');
        this.dialogRef.close();
      }
     
    }).catch(error => {
      this.showLoader = false;
      this.dialogRef.close();
    });
  }

}
