import { Component, OnInit , Inject } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { SelectedVendorDataService } from '../../../services/selected-vendor-data.service';
import { ActivatedRoute, Router } from "@angular/router";
import { ToastService } from '@bref/core';

@Component({
  selector: 'bre-confirm-edit-vendor-popup',
  templateUrl: './confirm-edit-vendor-popup.component.html',
  styleUrls: ['./confirm-edit-vendor-popup.component.scss']
})
export class ConfirmEditVendorPopupComponent implements OnInit {
  vendorName: string = "";
  currentUrl:string="";
  showLoader: boolean;
  constructor(private toast: ToastService,public dialogRef: MatDialogRef<ConfirmEditVendorPopupComponent>,private vendorData: SelectedVendorDataService,private matDialog: MatDialog,@Inject(MAT_DIALOG_DATA) public data: any,private router: Router,
  private route: ActivatedRoute) { 
    this.currentUrl = this.router.url.split('/')[this.router.url.split('/').length - 1]; 
  }

  ngOnInit(): void {
   
  }

    /**
   * Send the edited details to BE
   */
    editVendor(){
      this.showLoader=true;
      this.vendorData.editVendor(this.currentUrl).then(response => {
        this.showLoader=false;
        if(response[0].status?.toLowerCase() === 'success') {
          this.toast.success('Vendor details successfully updated.');
          this.matDialog.closeAll();
        } else {
          this.toast.error('Updation Failed');
          this.dialogRef.close();
        }
       
      }).catch(error => {
        this.showLoader = false;
        this.dialogRef.close();
      });
    }
      /**
   * Cancel button click.
   */
  cancelBoarding() {
    this.dialogRef.close()
  }
}
