import { Component, OnInit, ViewEncapsulation , Inject ,Output, EventEmitter  } from '@angular/core';
import { FormBuilder, FormControl, FormGroup } from "@angular/forms";
import {SelectedVendorDataService} from '../../../services/selected-vendor-data.service'; 
import {contactDetails, vendorDetails} from '../../../interfaces/vendor.interface';
import { ActivatedRoute, Router } from "@angular/router";
import {MAT_DIALOG_DATA} from '@angular/material/dialog';
import * as onBoardVendroConstants from '../../../constants/onboard-vendor-constants';
@Component({
  selector: 'bre-add-vendor',
  templateUrl: './add-vendor.component.html',
  styleUrls: ['./add-vendor.component.scss'],
  encapsulation: ViewEncapsulation.None
})
export class AddVendorComponent implements OnInit {
  formGroup: FormGroup;
  contactDetails: contactDetails;
  addedDevices = [];
  contactType = [];
  vendorNameInput: string;
  vendorNotesInput: string;
  showDeleteIcon: boolean = false;
  disableAddContact: boolean = true;
  isValidEmail:boolean [] = [true];
  isValidPhone:boolean [] = [true];
  vendor: any = "";
  vendorContactsEdit=[];
  @Output() saveChanges = new EventEmitter<boolean>();
  saveChangesTo: boolean = true;
  alreadyAdded = [];
  currentUrl:string="";
  isNameDisabled: boolean = false;
  
  

  constructor(private fb: FormBuilder, private selectedVendorDataService: SelectedVendorDataService,private router: Router,
    private route: ActivatedRoute,@Inject(MAT_DIALOG_DATA) public data:any) {
      this.currentUrl = this.router.url.split('/')[this.router.url.split('/').length - 1]; 
      this.isNameDisabled =  this.data&&this.data?.vendorData?true:false;
    this.vendorContactsEdit = this.data && this.data?.contacts;
    this.vendorContactsEdit?.map(contact => {
      this.addedDevices.push(
        this.fb.group({
          contactNotes: contact.notes,
          contactPhone: contact.phone,
          contactEmail: contact.email,
          contactName: contact.name
        }));
        this.contactType.push(contact.level);
        this.isValidEmail.push(true);
        this.isValidPhone.push(true);
    })
   
    if(this.data?.vendorData){
      this.vendorNameInput = this.data.vendorData.data.attributes.name;
      this.vendorNotesInput = this.data?.vendorData.data.attributes.notes;
    }else{
      this.vendorNameInput = null;
      this.vendorNotesInput = null;
    }
    this.alreadyAdded = this.addedDevices.slice();
    this.updateVendorDataToService();
  }

  ngOnInit(): void {
    
    this.vendor = this.data;    
    if(!this.vendorContactsEdit){
      this.addedDevices.push(
        this.fb.group({
          contactNotes: null,
          contactPhone: null,
          contactEmail: null,
          contactName: null
        }));
        
        this.contactType.push('Primary');
    }


      this.formGroup = this.fb.group ({
        vendorNameInput: [this.data?.vendorData ? this.data.vendorData.data.attributes.name : null],
      })
  }

  /**
   * Function is triggered on clicking of add contact buttons,
   * adds a row to the contact details as in secondary and other respectively.
   * Add contact button will disappera once two rows are added.
   */
  addContact() {
    switch(this.getAddedContactRowIds().length) {
      case 1: {
        this.addedDevices.push(
          this.fb.group({
            contactNotes: null,
            contactPhone: null,
            contactEmail: null,
            contactName: null
          }));
          this.contactType.push('Secondary');
          this.isValidEmail.push(true);
          this.isValidPhone.push(true);
          break; 
      }
      case 2: {
        this.addedDevices.push(
          this.fb.group({
            contactNotes: null,
            contactPhone: null,
            contactEmail: null,
            contactName: null
          }));
          this.contactType.push('Other');
          this.isValidEmail.push(true);
          this.isValidPhone.push(true);
          break; 
      }
    }
  }

  /**
   * This function is triggered when ever user clicks on delete contact details,
   * and then empties the row
   * @param rowId of the contact details
   */
  deleteContact(rowId) {
    if(this.getAddedContactRowIds().length === 1) {
      this.disableAddContact = true;
      this.addedDevices[rowId].patchValue({
        contactName: null,
        contactEmail: null,
        contactPhone: null,
        contactNotes: null
      });
    } else {
      delete this.addedDevices[rowId];
      if(this.contactType[rowId] === 'Primary') {
        const devicesLength = this.addedDevices.length;
        switch(this.getAddedContactRowIds().length) {
          case 1: {
            this.contactType[devicesLength-1] = 'Primary';
            break;
          }
          case 2: {
            this.contactType[devicesLength - 2] = 'Primary';
            this.contactType[devicesLength - 1] = 'Secondary';
            break;
          }
        }
      } 
      else if(this.contactType[rowId] === 'Secondary' && this.contactType[parseInt(rowId) + 1]) {
        this.contactType[this.addedDevices.length - 1] = 'Secondary';
      }
      delete this.contactType[rowId];
    }
    this.updateVendorDataToService();
  }

  /**
   * Get the row id
   * this function is called to get all the store ids
   */
  getAddedContactRowIds() {
    return Object.keys(this.addedDevices);
  }

  /**
   * On click on delete button on screen empties the complete data entered by user
   */
  emptyVendorDetails() {
    this.vendorNameInput = null;
    this.vendorNotesInput = null;
    this.addedDevices = [];
    this.addedDevices.push(
      this.fb.group({
        contactName: null,
        contactEmail: [null, {updateOn: 'blur'}],
        contactPhone: null,
        contactNotes: null
      },
      ));
    this.formGroup.patchValue({
      vendorNameInput : null
    });
    this.contactType = ['Primary'];
    this.disableAddContact = true;
    this.updateVendorDataToService();
  }

  /**
   * This function is trigered when ever there is a change in vendor name
   * and update the vendorNameInput value
   * @param event element change event
   */
  vendorNameChanged(event) {
    if (event.value !== '') {
      this.showDeleteIcon = true;
    }
    this.vendorNameInput = event.value;
    this.updateVendorDataToService();
  }

 /**
   * This function is trigered when ever there is a change in vendor notes
   * @param event element change event
   */
  vendorNotesChanged(event) {
    this.showDeleteIcon = true;
    this.updateVendorDataToService();
  }

  /**
   * 
   * @param event action event
   * @param rowId type number
   * This function is called when ever a change in contact details happens and updates its values on valid response
   * to service
   */
  addedDeviceContactChanges(event, rowId) {
    if (rowId === "0" && (onBoardVendroConstants.EMAIL_REG.test(event.value) || onBoardVendroConstants.PHONE_REG.test(event.value)) && this.addedDevices[rowId].value.contactName) {
      this.disableAddContact = false;
      this.showDeleteIcon = true;
    }
    if(event.controlName === 'contactEmail' && event.value && event.value !== '') {
      this.isValidEmail[rowId] = onBoardVendroConstants.EMAIL_REG.test(event.value); 
    } else if (event.controlName === 'contactPhone' && event.value && event.value !== '') {
      this.isValidPhone[rowId] = onBoardVendroConstants.PHONE_REG.test(event.value); 
    } else if(event.controlName === 'contactPhone'  && event.value === '' || event.value === null) {
      this.isValidPhone[rowId] = true;
    } else if(event.controlName === 'contactEmail'  && event.value === '' || event.value === null) {
      this.isValidEmail[rowId] = true;
    }
    this.alreadyAdded.map((item) => {
      if(this.saveChangesTo){
        !item.pristine && item.dirty ? this.saveChangesTo = false : this.saveChangesTo = true;
      }     
    })
      this.updateVendorDataToService();
  }
  /**
   * This function updates vendor details to service
   */
  updateVendorDataToService() {
    const data: vendorDetails[] = [];
    const contactDetails = [];
    for (let rowId in this.addedDevices) {
        contactDetails.push({
          notes: this.addedDevices[rowId].value.contactNotes,
          phone: this.addedDevices[rowId].value.contactPhone ? this.addedDevices[rowId].value.contactPhone: '',
          email: this.addedDevices[rowId].value.contactEmail ? this.addedDevices[rowId].value.contactEmail : '',
          name: this.addedDevices[rowId].value.contactName,
          level: this.contactType[rowId]
      });
    }
    data.push({
      'vendorName': this.vendorNameInput,
      'vendorNotes': this.vendorNotesInput,
       contactDetails
    });
    
    this.alreadyAdded.map((item) => {
      if(this.saveChangesTo){
        !item.pristine && item.dirty ? this.saveChangesTo = false : this.saveChangesTo = true;
      }     
    })
    this.saveChanges.emit(this.saveChangesTo);
    this.selectedVendorDataService.setAddVendor(data);
  }

}