import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { CoreModule, DialogService } from '@bref/core';
import {SelectedVendorDataService} from '../../../services/selected-vendor-data.service';
import { FormBuilder, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { AccordionModule } from 'primeng/accordion';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import { RouterTestingModule } from "@angular/router/testing";
import { AddVendorComponent } from './add-vendor.component';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';


const mockMatDialogRef = { close: jest.fn() };
describe('AddVendorComponent', () => {
  let component: AddVendorComponent;
  let fixture: ComponentFixture<AddVendorComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ AddVendorComponent],
      imports: [CoreModule, FormsModule, AccordionModule, NoopAnimationsModule,RouterTestingModule],
      providers: [ SelectedVendorDataService, DialogService ,{ provide: MAT_DIALOG_DATA, useValue: [] },
      { provide: MatDialogRef, useValue: mockMatDialogRef }]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(AddVendorComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });
});
