import { Component, OnInit, Inject, ViewEncapsulation } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { FormBuilder } from "@angular/forms";
import { SelectedVendorDataService } from '../../../services/selected-vendor-data.service';
import * as onBoardVendroConstants from '../../../constants/onboard-vendor-constants';
import { vendorTypeDetails} from '../../../interfaces/vendor.interface';

@Component({
  selector: 'bre-add-vendor-device-type',
  templateUrl: './add-vendor-device-type.component.html',
  styleUrls: ['./add-vendor-device-type.component.scss'],
  encapsulation: ViewEncapsulation.None
})
export class AddVendorDeviceTypeComponent implements OnInit {
  activeTab: boolean[] = [];
  addedDeviceTypes = [];
  addedAttributes = [];
  nextStoreRowIdIndex = 0;
  deviceCategory = onBoardVendroConstants.DEVICE_TYPE;
  customAttributeVal: string = "";

  defaultKeys = onBoardVendroConstants.DEFAULT_KEYS;
 
  customKeys = onBoardVendroConstants.CONSTANT_KEYS;

  constructor(@Inject(DOCUMENT) private document, private fb: FormBuilder, private selectedVendorType: SelectedVendorDataService) {
    this.insertNewDeviceType();
  }

  ngOnInit(): void {
    this.activeTab[0] = true;
  }

  /**
   * Add parent row
   * 
   * this function is called when user adds a new store
   */

  async insertNewDeviceType() {
    const rowId = this.nextStoreRowIdIndex++;
    this.addedDeviceTypes = {
      ...this.addedDeviceTypes,
      [rowId]: this.fb.group({
        deviceType: "",
        deviceTypeCategory: "",
        addCustomKeys: "",
        deviceAbbreviation: ""
      })
    };
    this.addedDeviceTypes[rowId].addControl('customKeys', this.fb.array([{
      name: "IP Address",
      type: "Suggested"
    }, {
      name: "MAC Address",
      type: "Suggested"
    }, {
      name: "Lane Number",
      type: "Suggested"
    },
    {
      name: "Hardware Version",
      type: "Suggested"
    }
  ]));
    this.activeTab = this.activeTab.map(item => {
      return item = false;
    })
    this.activeTab[rowId] = true;
    this.onTabOpen(rowId);
  }

  /**
* Get the row id
* this function is called to get all the store ids
*/
  getAddedDeviceTypesRowIds() {
    return Object.keys(this.addedDeviceTypes);
  }

  /**
* Close tab
* @param event - tab index
* this function is called when user closes the tab
*/
  onTabClose(event) {
    let ids = "header-display" + event;
    var x = this.document.getElementById(ids);
    if (x !== null) x.style.display = "block";
  }

  /**
 * Open tab
 * @param event - tab index
 * this function is called when user opens the tab or close another tab
 */
  onTabOpen(event?) {
    let headerElem = this.document.querySelectorAll(".add-vendor__accordion-tab_header");
    headerElem.forEach((headElem: HTMLElement) => {
      headElem.style.display = "block";
    });
    let contentElem = document.querySelectorAll(".maindiv");
    contentElem.forEach((content, index, array) => {
      this.activeTab[index] = false;
      if (!event && index === array.length - 1) {
        this.activeTab[index + 1] = true;
      }
    });
    if (event !== null && event !== undefined) {
      this.activeTab[event] = true;
      let ids = "header-display" + event;
      let x = this.document.getElementById(ids);
      if (x !== null) {
        x.style.display = "none";
      }
    }
  }

  removeDeviceType(rowid) {
    if (this.getAddedDeviceTypesRowIds().length > 1) {
      delete this.addedDeviceTypes[rowid];
      delete this.activeTab[rowid];
    }
    this.updateDeviceDataToService();
  }

  removeCustomAttribute(rowId, index) {
    if (this.addedDeviceTypes[rowId].value.customKeys[index].name === 'IP Address' || this.addedDeviceTypes[rowId].value.customKeys[index].name === 'MAC Address' || this.addedDeviceTypes[rowId].value.customKeys[index].name === 'Lane Number') {
      this.addedDeviceTypes[rowId].value.customKeys[index].type = 'Suggested';
    } else {
      this.addedDeviceTypes[rowId].value.customKeys.splice(index, 1);
    }
    this.updateDeviceDataToService();
  }

  addCustomAttribute(rowId, key) {
    this.addedDeviceTypes[rowId].value.customKeys[key].type = 'New';
    this.updateDeviceDataToService();
  }

  addNewCustomAttribute(rowId) {
    if (this.addedDeviceTypes[rowId].value.addCustomKeys != '') {
      this.addedDeviceTypes[rowId].value.customKeys.unshift({
        type: "New",
        name: this.addedDeviceTypes[rowId].value.addCustomKeys
      })
      this.addedDeviceTypes[rowId].patchValue({
        addCustomKeys: ''
      });
    }
    this.updateDeviceDataToService();
  }

  /**
* Update the data to the service
* 
* this function is called when user changes anything on the form,
* it will store the changes to the service
*/
  updateDeviceDataToService() {
    const data: vendorTypeDetails[] = [];
    for (let rowId in this.addedDeviceTypes) {
      data.push({
        deviceType: this.addedDeviceTypes[rowId].value.deviceType,
        deviceTypeCategory: this.addedDeviceTypes[rowId].value.deviceTypeCategory,
        deviceTypeAttributes: this.addedDeviceTypes[rowId].value.customKeys,
        deviceFlag: this.addedDeviceTypes[rowId].value.deviceTypeCategory === 'AWS' ? true : false,
        deviceAbbreviation: this.addedDeviceTypes[rowId].value.deviceAbbreviation
      });
    }
    this.selectedVendorType.setAddVendorDeviceType(data)
  }
}
