import { Component, OnInit } from '@angular/core';
import { SelectedVendorDataService } from '../../../services/selected-vendor-data.service';
import { FullscreenDialogService } from '../../../services/fullscreen-dialog.service';
import { ConfirmVendorOnboardingPopupComponent } from '../confirm-vendor-onboarding-popup/confirm-vendor-onboarding-popup.component';

@Component({
  selector: 'bre-add-vendor-confirmation-summary',
  templateUrl: './add-vendor-confirmation-summary.component.html',
  styleUrls: ['./add-vendor-confirmation-summary.component.scss']
})
export class AddVendorConfirmationSummaryComponent implements OnInit {

  deviceType;
  deviceDetails;

  constructor(private vendorData: SelectedVendorDataService, private dialogSerive: FullscreenDialogService) { }

  ngOnInit(): void {
    this.vendorData.addDeviceType.subscribe(data => {
      this.deviceType = data;
    });
    this.vendorData.addDevice.subscribe(data => {
      this.deviceDetails = data[0];
    });
  }

  redirectPage(pageNumber) {
    this.dialogSerive.changePage(pageNumber);
  }
}
